/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.UUID;

public class Company
implements Parcelable {
    public static final Parcelable.Creator<Company> CREATOR = new Parcelable.Creator<Company>(){

        public Company createFromParcel(Parcel source) {
            return new Company(source);
        }

        public Company[] newArray(int size) {
            return new Company[size];
        }
    };
    private final UUID id;
    private final String name;
    private final String countryCode;
    private final String uniqueId;

    public static Builder builder() {
        return new Builder();
    }

    private Company(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.countryCode = builder.countryCode;
        this.uniqueId = builder.uniqueId;
    }

    protected Company(Parcel in) {
        this.id = (UUID)in.readSerializable();
        this.name = in.readString();
        this.countryCode = in.readString();
        this.uniqueId = in.readString();
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Company)) {
            return false;
        }
        Company company = (Company)obj;
        return SDKEqualsBuilder.start().equals(this.id, company.id).equals(this.countryCode, company.countryCode).equals(this.name, company.name).equals(this.uniqueId, company.uniqueId).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.id).append(this.countryCode).append(this.name).append(this.uniqueId).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.id);
        dest.writeString(this.name);
        dest.writeString(this.countryCode);
        dest.writeString(this.uniqueId);
    }

    public static class Builder {
        private UUID id;
        private String name;
        private String countryCode;
        private String uniqueId;

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Company build() {
            return new Company(this);
        }
    }
}

