/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class FirmwareRevisions {
    public static final Set<String> NORMAL_MODE_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("2.5", "2.6", "2.7", "2.8", "2.9", "3.0", "3.1")));
    public static final Set<String> SECURE_MODE_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("4.0", "4.1")));
    public static final Set<String> NON_SWITCHABLE_PROFILE_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("2.5", "2.6", "2.7", "2.8", "2.9")));
    public static final Set<String> SWITCHABLE_PROFILE_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("3.0", "3.1", "4.0", "4.1")));
    public static final Set<String> IBEACON_PROFILE_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("2.5", "2.6", "2.7")));
    public static final Set<String> EDDYSTONE_PROFILE_FIRMWARE_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("2.9")));
    public static final Set<String> INTERLEAVING_PACKETS_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("4.1")));

    public static boolean isSwitchable(String firmwareVersion) {
        return !NON_SWITCHABLE_PROFILE_FIRMWARE_VERSIONS.contains(firmwareVersion);
    }

    public static boolean isIBeaconOnly(String firmwareVersion) {
        return IBEACON_PROFILE_FIRMWARE_VERSIONS.contains(firmwareVersion);
    }

    public static boolean isEddystoneOnly(String firmwareVersion) {
        return EDDYSTONE_PROFILE_FIRMWARE_VERSIONS.contains(firmwareVersion);
    }

    public static boolean isInterleavingAvailable(String firmwareVersion) {
        return INTERLEAVING_PACKETS_VERSIONS.contains(firmwareVersion);
    }
}

