/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.events;

import com.google.gson.Gson;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.EventsService;
import com.kontakt.sdk.android.common.model.EventPacket;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class CollectEventsRequestExecutor
extends RequestExecutor<Void> {
    private final EventsService eventsService;
    private final EventPacket eventPacket;
    private final Gson gson = new Gson();

    public CollectEventsRequestExecutor(EventsService eventsService, EventPacket eventPacket) {
        this.eventsService = eventsService;
        this.eventPacket = eventPacket;
    }

    @Override
    protected Call<Void> prepareCall() {
        return this.eventsService.collectEvents(this.params());
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("timestamp", String.valueOf(this.eventPacket.getTimestamp()));
        params.put("events", this.gson.toJson(this.eventPacket.getEvents()));
        return params;
    }
}

