/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.devices.DevicesBaseRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.response.paginated.Devices;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class IBeaconsRequestExecutor
extends DevicesBaseRequestExecutor {
    private final DevicesService devicesService;
    private String[] iBeaconIDs;

    public IBeaconsRequestExecutor(DevicesService devicesService) {
        this.devicesService = devicesService;
        this.profile = DeviceProfile.IBEACON;
    }

    public IBeaconsRequestExecutor withIds(IBeaconId ... iBeaconIDs) {
        SDKPreconditions.checkNotNull(iBeaconIDs, "iBeacon IDs cannot be null");
        int size = iBeaconIDs.length;
        this.iBeaconIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            this.iBeaconIDs[i] = iBeaconIDs[i].toString();
        }
        return this;
    }

    public IBeaconsRequestExecutor withIds(List<IBeaconId> iBeaconIDs) {
        SDKPreconditions.checkNotNull(iBeaconIDs, "iBeacon IDs cannot be null");
        int size = iBeaconIDs.size();
        this.iBeaconIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            IBeaconId iBeaconId = iBeaconIDs.get(i);
            this.iBeaconIDs[i] = iBeaconId.toString();
        }
        return this;
    }

    @Override
    protected Call<Devices> prepareCall() {
        Call<Devices> call = this.eTag != null ? this.devicesService.getDevices(this.params(), this.eTag) : this.devicesService.getDevices(this.params());
        return call;
    }

    @Override
    public IBeaconsRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public IBeaconsRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public IBeaconsRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public IBeaconsRequestExecutor access(Access access) {
        super.access(access);
        return this;
    }

    @Override
    public IBeaconsRequestExecutor managerIds(UUID ... managerIds) {
        super.managerIds(managerIds);
        return this;
    }

    @Override
    public IBeaconsRequestExecutor managerIds(List<UUID> managerIds) {
        super.managerIds(managerIds);
        return this;
    }

    @Override
    public IBeaconsRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public IBeaconsRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.iBeaconIDs != null) {
            params.put("bid", StringUtils.join(this.iBeaconIDs, ","));
        }
        return params;
    }
}

