/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.devices.DevicesBaseRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.response.paginated.Devices;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class EddystonesRequestExecutor
extends DevicesBaseRequestExecutor {
    private final DevicesService devicesService;
    private String[] eddystoneUIDs;

    public EddystonesRequestExecutor(DevicesService devicesService) {
        this.devicesService = devicesService;
        this.profile = DeviceProfile.EDDYSTONE;
    }

    public EddystonesRequestExecutor withIds(EddystoneUid ... eddystoneUIDs) {
        SDKPreconditions.checkNotNull(eddystoneUIDs, "eddystone UIDs cannot be null");
        int size = eddystoneUIDs.length;
        this.eddystoneUIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            this.eddystoneUIDs[i] = eddystoneUIDs[i].toString();
        }
        return this;
    }

    public EddystonesRequestExecutor withIds(List<EddystoneUid> eddystoneUIDs) {
        SDKPreconditions.checkNotNull(eddystoneUIDs, "eddystone UIDs cannot be null");
        int size = eddystoneUIDs.size();
        this.eddystoneUIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            EddystoneUid eddystoneUID = eddystoneUIDs.get(i);
            this.eddystoneUIDs[i] = eddystoneUID.toString();
        }
        return this;
    }

    @Override
    protected Call<Devices> prepareCall() {
        Call<Devices> call = this.eTag != null ? this.devicesService.getDevices(this.params(), this.eTag) : this.devicesService.getDevices(this.params());
        return call;
    }

    @Override
    public EddystonesRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public EddystonesRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public EddystonesRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public EddystonesRequestExecutor access(Access access) {
        super.access(access);
        return this;
    }

    @Override
    public EddystonesRequestExecutor managerIds(UUID ... managerIds) {
        super.managerIds(managerIds);
        return this;
    }

    @Override
    public EddystonesRequestExecutor managerIds(List<UUID> managerIds) {
        super.managerIds(managerIds);
        return this;
    }

    @Override
    public EddystonesRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public EddystonesRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.eddystoneUIDs != null) {
            params.put("euid", StringUtils.join(this.eddystoneUIDs, ","));
        }
        return params;
    }
}

