/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.devices.DevicesBaseRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.response.paginated.Devices;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class DevicesRequestExecutor
extends DevicesBaseRequestExecutor {
    private final DevicesService devicesService;
    private String[] uniqueIds;
    private String unassignedFor;

    public DevicesRequestExecutor(DevicesService devicesService) {
        this.devicesService = devicesService;
    }

    public DevicesRequestExecutor withIds(String ... uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        this.uniqueIds = uniqueIds;
        return this;
    }

    public DevicesRequestExecutor withIds(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
        return this;
    }

    public DevicesRequestExecutor type(DeviceType type) {
        SDKPreconditions.checkNotNull(type, "type cannot be null");
        this.type = type;
        return this;
    }

    public DevicesRequestExecutor profile(DeviceProfile profile) {
        SDKPreconditions.checkNotNull(profile, "profile cannot be null");
        this.profile = profile;
        return this;
    }

    public DevicesRequestExecutor unassignedFor(UUID managerId) {
        SDKPreconditions.checkNotNull(managerId, "manager id cannot be null");
        this.unassignedFor = managerId.toString();
        return this;
    }

    @Override
    protected Call<Devices> prepareCall() {
        Call<Devices> call = this.eTag != null ? (this.unassignedFor != null ? this.devicesService.getUnassignedDevices(this.unassignedFor, this.params(), this.eTag) : this.devicesService.getDevices(this.params(), this.eTag)) : (this.unassignedFor != null ? this.devicesService.getUnassignedDevices(this.unassignedFor, this.params()) : this.devicesService.getDevices(this.params()));
        return call;
    }

    @Override
    public DevicesRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public DevicesRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public DevicesRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public DevicesRequestExecutor access(Access access) {
        super.access(access);
        return this;
    }

    @Override
    public DevicesRequestExecutor managerIds(UUID ... managerIds) {
        super.managerIds(managerIds);
        return this;
    }

    @Override
    public DevicesRequestExecutor managerIds(List<UUID> managerIds) {
        super.managerIds(managerIds);
        return this;
    }

    @Override
    public DevicesRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public DevicesRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.uniqueIds != null) {
            params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        }
        return params;
    }
}

