/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.response.paginated.CredentialsList;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class CredentialsListRequestExecutor
extends RequestExecutor<CredentialsList> {
    private final DevicesService devicesService;
    private final List<String> uniqueIds;

    public CredentialsListRequestExecutor(DevicesService devicesService, List<String> uniqueIds) {
        this.devicesService = devicesService;
        this.uniqueIds = uniqueIds;
    }

    @Override
    protected Call<CredentialsList> prepareCall() {
        return this.devicesService.getDeviceCredentialsByUniqueIds(StringUtils.join(this.uniqueIds, ","));
    }

    @Override
    protected Map<String, String> params() {
        return new HashMap<String, String>();
    }
}

