/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.configs;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ConfigsService;
import com.kontakt.sdk.android.cloud.response.paginated.Configs;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class SecureConfigsRequestExecutor
extends PaginatedRequestExecutor<Configs> {
    private final ConfigsService configsService;
    private String[] uniqueIds;

    public SecureConfigsRequestExecutor(ConfigsService configsService) {
        this.configsService = configsService;
    }

    public SecureConfigsRequestExecutor withIds(String ... uniqueIds) {
        this.uniqueIds = SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return this;
    }

    public SecureConfigsRequestExecutor withIds(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
        return this;
    }

    @Override
    public SecureConfigsRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public SecureConfigsRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public SecureConfigsRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public SecureConfigsRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public SecureConfigsRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Call<Configs> prepareCall() {
        return this.configsService.getSecureConfigs(this.params());
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.uniqueIds != null) {
            params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        }
        return params;
    }
}

