/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.HashMap;
import java.util.Map;

public abstract class PaginatedRequestExecutor<T>
extends RequestExecutor<T> {
    protected int startIndex = -1;
    protected int maxResult = -1;
    protected String query;
    protected String orderBy;
    protected String order;
    protected String eTag;

    public PaginatedRequestExecutor startIndex(int startIndex) {
        SDKPreconditions.checkState(startIndex >= 0, "start index cannot be negative");
        this.startIndex = startIndex;
        return this;
    }

    public PaginatedRequestExecutor maxResult(int maxResult) {
        SDKPreconditions.checkState(maxResult > 0, "max result cannot be zero or negative");
        this.maxResult = maxResult;
        return this;
    }

    public PaginatedRequestExecutor filter(String query) {
        this.query = SDKPreconditions.checkNotNull(query, "query cannot be null");
        return this;
    }

    public PaginatedRequestExecutor orderBy(OrderBy orderBy, Order order) {
        this.orderBy = SDKPreconditions.checkNotNull(orderBy, "orderBy cannot be null").value();
        this.order = SDKPreconditions.checkNotNull(order, "order cannot be null").name();
        return this;
    }

    public PaginatedRequestExecutor eTag(String eTag) {
        this.eTag = SDKPreconditions.checkNotNull(eTag, "eTag cannot be null");
        return this;
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.maxResult > 0) {
            params.put("maxResult", String.valueOf(this.maxResult));
        }
        if (this.startIndex >= 0) {
            params.put("startIndex", String.valueOf(this.startIndex));
        }
        if (this.query != null) {
            params.put("q", this.query);
        }
        if (this.order != null && this.orderBy != null) {
            params.put("order", this.order);
            params.put("orderBy", this.orderBy);
        }
        return params;
    }
}

