/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.util;

import com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.IBeaconScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Collection;

public class ScanContextUtils {
    public static ScanContext cloneWithNewSpaces(ScanContext oldContext, Collection<IBeaconRegion> regions, Collection<IEddystoneNamespace> namespaces) {
        SDKPreconditions.checkNotNull(oldContext);
        SDKPreconditions.checkNotNull(regions);
        SDKPreconditions.checkNotNull(namespaces);
        IBeaconScanContext oldIBeaconContext = oldContext.getIBeaconScanContext();
        EddystoneScanContext oldEddystoneContext = oldContext.getEddystoneScanContext();
        return ScanContextUtils.cloneBuilder(oldContext).setEddystoneScanContext(((EddystoneScanContext.Builder)((EddystoneScanContext.Builder)new EddystoneScanContext.Builder().setTriggerFrameTypes(oldEddystoneContext.getTriggerFrameTypes()).setURLFilters(oldEddystoneContext.getURLFilters()).setTLMFilters(oldEddystoneContext.getTLMFilters()).setUIDFilters(oldEddystoneContext.getUIDFilters()).setDistanceSort(oldEddystoneContext.getDistanceSort())).setEventTypes(oldEddystoneContext.getEventTypes())).setEddystoneNamespaces(namespaces).build()).setIBeaconScanContext(((IBeaconScanContext.Builder)((IBeaconScanContext.Builder)new IBeaconScanContext.Builder().setIBeaconFilters(oldIBeaconContext.getFilters()).setEventTypes(oldIBeaconContext.getEventTypes())).setDistanceSort(oldIBeaconContext.getDistanceSort())).setIBeaconRegions(regions).build()).build();
    }

    public static ScanContext.Builder cloneBuilder(ScanContext scanContext) {
        return new ScanContext.Builder().setIBeaconScanContext(scanContext.getIBeaconScanContext()).setEddystoneScanContext(scanContext.getEddystoneScanContext()).setScanMode(scanContext.getScanMode()).setScanPeriod(scanContext.getScanPeriod()).setForceScanConfiguration(scanContext.getForceScanConfiguration()).setActivityCheckConfiguration(scanContext.getActivityCheckConfiguration()).setDevicesUpdateCallbackInterval(scanContext.getDevicesUpdateCallbackInterval()).setRssiCalculator(scanContext.getRssiCalculator());
    }
}

