/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.util.SparseArray;
import com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.IBeaconScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.ProximityService;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanController;

final class ServiceScanConfiguration {
    static final Item NULL = new Item(new ScanContext.Builder().setEddystoneScanContext(EddystoneScanContext.DEFAULT).setIBeaconScanContext(IBeaconScanContext.DEFAULT).build(), ScanConfiguration.NULL, ForceScanScheduler.DISABLED, ScanController.NULL);
    private final SparseArray<Item> scanConfigurationMap = new SparseArray<Item>(){

        public Item get(int key) {
            return (Item)super.get(key, (Object)NULL);
        }
    };
    private final SparseArray<ProximityService.State> scanStateMap = new SparseArray<ProximityService.State>(){

        public ProximityService.State get(int key) {
            return (ProximityService.State)((Object)super.get(key, (Object)ProximityService.State.IDLE));
        }
    };

    ServiceScanConfiguration() {
    }

    ProximityService.State getState(int proximityManagerId) {
        return (ProximityService.State)((Object)this.scanStateMap.get(proximityManagerId));
    }

    void updateState(int proximityManagerId, ProximityService.State newState) {
        this.scanStateMap.put(proximityManagerId, (Object)newState);
    }

    ScanContext getScanContext(int proximityManagerId) {
        return ((Item)this.scanConfigurationMap.get((int)proximityManagerId)).scanContext;
    }

    ScanConfiguration getScanConfiguration(int proximityManagerId) {
        return ((Item)this.scanConfigurationMap.get((int)proximityManagerId)).scanConfiguration;
    }

    ForceScanScheduler getForceScanScheduler(int proximityManagerId) {
        return ((Item)this.scanConfigurationMap.get((int)proximityManagerId)).forceScanScheduler;
    }

    ScanController getScanController(int proximityManagerId) {
        return ((Item)this.scanConfigurationMap.get((int)proximityManagerId)).scanController;
    }

    void addListener(int proximityManagerId, InternalProximityListener proximityListener) {
        ((Item)this.scanConfigurationMap.get((int)proximityManagerId)).scanConfiguration.addListener(proximityListener);
    }

    void removeListener(int proximityManagerId, InternalProximityListener proximityListener) {
        ((Item)this.scanConfigurationMap.get((int)proximityManagerId)).scanConfiguration.removeListener(proximityListener);
    }

    void clear() {
        this.scanConfigurationMap.clear();
        this.scanStateMap.clear();
    }

    void add(int proximityManagerId, Item item) {
        this.scanConfigurationMap.put(proximityManagerId, (Object)item);
    }

    Item get(int proximityManagerId) {
        return (Item)this.scanConfigurationMap.get(proximityManagerId);
    }

    int size() {
        return this.scanConfigurationMap.size();
    }

    Item remove(int proximityManagerId) {
        Item item = (Item)this.scanConfigurationMap.get(proximityManagerId);
        this.scanStateMap.remove(proximityManagerId);
        this.scanConfigurationMap.remove(proximityManagerId);
        return item;
    }

    static final class Item {
        final ScanContext scanContext;
        final ScanConfiguration scanConfiguration;
        final ForceScanScheduler forceScanScheduler;
        final ScanController scanController;

        Item(ScanContext scanContext, ScanConfiguration scanConfiguration, ForceScanScheduler forceScanScheduler, ScanController scanController) {
            this.scanContext = scanContext;
            this.scanConfiguration = scanConfiguration;
            this.forceScanScheduler = forceScanScheduler;
            this.scanController = scanController;
        }
    }
}

