/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.os.Messenger;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.Callbacks;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.ListenerAccessor;
import com.kontakt.sdk.android.ble.service.Runners;
import com.kontakt.sdk.android.ble.service.ScanCompat;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanController;
import com.kontakt.sdk.android.common.log.Logger;

@TargetApi(value=18)
final class ScanCompatJB
extends ScanCompat {
    ScanCompatJB() {
    }

    @Override
    public ScanConfiguration createScanConfiguration(ListenerAccessor listenerAccessor, ScanContext scanContext, Messenger messenger) {
        BleScanCallback scanCallback = Callbacks.newCallback(new Callbacks.Configuration.Builder().addMonitoringListeners(listenerAccessor.getMonitoringListeners()).setScanContext(scanContext).setServiceMessenger(messenger).build());
        return new ScanCompat.AbstractScanConfiguration(scanContext, scanCallback){};
    }

    @Override
    public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
        return new ScanController.Builder().setScanActiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration)).setScanPassiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration)).setScanPeriod(configuration.getScanContext().getScanPeriod()).setForceScanScheduler(forceScanScheduler).build();
    }

    @Override
    public ForceScanScheduler createForceScanScheduler(ScanConfiguration configuration) {
        ScanContext scanContext = configuration.getScanContext();
        if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
            return ForceScanScheduler.DISABLED;
        }
        return new ForceScanScheduler(Runners.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
    }

    @Override
    @TargetApi(value=18)
    public void onScanStart(ScanConfiguration configuration) {
        BleScanCallback scanCallback = configuration.getScanCallback();
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.startLeScan((BluetoothAdapter.LeScanCallback)scanCallback);
        } else {
            Logger.d("Scan start requested but Bluetooth Adapter is null.");
        }
    }

    @Override
    public void onScanStop(BleScanCallback callback) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.stopLeScan((BluetoothAdapter.LeScanCallback)callback);
        }
    }
}

