/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.Collection;

@TargetApi(value=21)
abstract class MonitorCallbackL
extends ScanCallback
implements BleScanCallback {
    protected final MonitorCallback wrappedScanCallback;

    MonitorCallbackL(MonitorCallback scanCallback) {
        SDKPreconditions.checkNotNull(scanCallback, "Wrapped scan callback is null");
        this.wrappedScanCallback = scanCallback;
    }

    public void onScanResult(int callbackType, ScanResult result) {
        if (callbackType != 1) {
            return;
        }
        ScanRecord scanRecord = result.getScanRecord();
        if (scanRecord == null) {
            return;
        }
        this.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        this.wrappedScanCallback.onLeScan(device, rssi, scanRecord);
    }

    public void onScanFailed(int errorCode) {
        switch (errorCode) {
            case 4: {
                Logger.d("Scan failed - feature unsupported");
                break;
            }
            case 3: {
                Logger.d("Scan failed - internal error");
                break;
            }
            case 2: {
                Logger.d("Scan failed - application registration failed");
                break;
            }
            case 1: {
                Logger.d("Scan failed - application already started");
                break;
            }
            default: {
                Logger.d("Scan failed - error code = " + errorCode);
            }
        }
    }

    @Override
    public Collection<InternalProximityListener> getMonitoringListeners() {
        return this.wrappedScanCallback.getMonitoringListeners();
    }

    @Override
    public void addListener(InternalProximityListener proximityListener) {
        this.wrappedScanCallback.addListener(proximityListener);
    }

    @Override
    public void removeListener(InternalProximityListener proximityListener) {
        this.wrappedScanCallback.removeListener(proximityListener);
    }

    @Override
    public void close() throws IOException {
        this.wrappedScanCallback.close();
    }

    void onMonitorStarted() {
        this.wrappedScanCallback.onMonitorCycleStart();
    }

    void onMonitorStopped() {
        this.wrappedScanCallback.onMonitorCycleStop();
    }

    void notifyScanStarted() {
        this.wrappedScanCallback.notifyScanStarted();
    }

    void notifyScanStopped() {
        this.wrappedScanCallback.notifyScanStopped();
    }
}

