/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.bluetooth.BluetoothDevice;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.Callbacks;
import com.kontakt.sdk.android.ble.service.DefaultBluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

abstract class MonitorCallback
implements BleScanCallback,
DiscoveryContract {
    private static final String TAG = MonitorCallback.class.getSimpleName();
    private final Messenger serviceMessenger;
    protected final BluetoothDeviceDiscoverer bluetoothDeviceDiscoverer;
    private final Map<Integer, InternalProximityListener> monitoringListenerMap;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final ScanPeriod scanPeriod;
    private ScheduledExecutorService periodicActivityCheckExecutor;

    MonitorCallback(Callbacks.Configuration configuration) {
        this.bluetoothDeviceDiscoverer = new DefaultBluetoothDeviceDiscoverer(configuration.scanContext, this);
        this.serviceMessenger = configuration.messenger;
        this.monitoringListenerMap = new ConcurrentHashMap<Integer, InternalProximityListener>();
        this.activityCheckConfiguration = configuration.scanContext.getActivityCheckConfiguration();
        this.scanPeriod = configuration.scanContext.getScanPeriod();
        this.addRegisteredListeners(configuration);
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (!this.isAnyListenerRegistered() && KontaktSDK.isInitialized()) {
            return;
        }
        if (device == null) {
            Logger.d("Remote device discovered but is null");
            return;
        }
        Logger.d(String.format("Device discovered %s", device.toString()));
        boolean isDeviceDiscovered = this.bluetoothDeviceDiscoverer.performDiscovery(device, rssi, scanRecord);
        if (!isDeviceDiscovered) {
            Logger.d(String.format("Device found but not recognized as Beacon [name: %s, address: %s]", device.getName(), device.getAddress()));
        }
    }

    @Override
    public void close() {
        this.bluetoothDeviceDiscoverer.disable();
        this.monitoringListenerMap.clear();
    }

    @Override
    public Collection<InternalProximityListener> getMonitoringListeners() {
        return Collections.unmodifiableCollection(new ArrayList<InternalProximityListener>(this.monitoringListenerMap.values()));
    }

    @Override
    public void addListener(InternalProximityListener proximityListener) {
        int hashCode = System.identityHashCode(proximityListener);
        InternalProximityListener insertion = this.monitoringListenerMap.put(hashCode, proximityListener);
        if (insertion == null) {
            Logger.d("MonitoringListener registered: " + hashCode);
        }
    }

    @Override
    public void removeListener(InternalProximityListener proximityListener) {
        int hashCode = System.identityHashCode(proximityListener);
        InternalProximityListener deletion = this.monitoringListenerMap.remove(hashCode);
        if (deletion != null) {
            Logger.d("MonitoringListener unregistered: " + hashCode);
        }
    }

    @Override
    public void onMonitorCycleStart() {
        if (this.scanPeriod != ScanPeriod.RANGING) {
            for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
                proximityListener.onMonitoringCycleStart();
            }
        }
        this.startPeriodicInactivityCheck();
    }

    @Override
    public void onMonitorCycleStop() {
        if (this.scanPeriod != ScanPeriod.RANGING) {
            for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
                proximityListener.onMonitoringCycleStop();
            }
        }
        this.stopPeriodicInactivityCheck();
    }

    @Override
    public void onEvent(BluetoothDeviceEvent event) {
        for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
            proximityListener.onEvent(event);
        }
    }

    void notifyScanStarted() {
        this.sendMessage(1);
    }

    void notifyScanStopped() {
        this.sendMessage(2);
    }

    protected boolean sendMessage(int messageCode) {
        try {
            this.serviceMessenger.send(Message.obtain(null, (int)messageCode));
            return true;
        }
        catch (RemoteException e) {
            Logger.e(TAG + " Error occures when sending message", e);
            return false;
        }
    }

    private boolean isAnyListenerRegistered() {
        return !this.monitoringListenerMap.isEmpty();
    }

    private void addRegisteredListeners(Callbacks.Configuration configuration) {
        for (InternalProximityListener proximityListener : configuration.proximityListeners) {
            this.addListener(proximityListener);
        }
    }

    private void startPeriodicInactivityCheck() {
        if (this.activityCheckConfiguration == ActivityCheckConfiguration.DISABLED) {
            return;
        }
        long checkPeriod = this.activityCheckConfiguration.getCheckPeriod();
        this.periodicActivityCheckExecutor = Executors.newSingleThreadScheduledExecutor();
        this.periodicActivityCheckExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    MonitorCallback.this.bluetoothDeviceDiscoverer.evictInactiveDevices();
                }
                catch (Exception e) {
                    Logger.e(TAG + "Error during evicting", e);
                }
            }
        }, checkPeriod, checkPeriod, TimeUnit.MILLISECONDS);
    }

    private void stopPeriodicInactivityCheck() {
        if (this.activityCheckConfiguration == ActivityCheckConfiguration.DISABLED) {
            return;
        }
        this.periodicActivityCheckExecutor.shutdownNow();
    }
}

