/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.math;

import com.kontakt.sdk.android.ble.math.AbstractUnivariateStatistic;
import com.kontakt.sdk.android.ble.math.StorelessUnivariateStatistic;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

abstract class AbstractStorelessUnivariateStatistic
extends AbstractUnivariateStatistic
implements StorelessUnivariateStatistic {
    private static final long POSITIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(0.0);
    private static final long NEGATIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(-0.0);
    private static final long SGN_MASK = Long.MIN_VALUE;

    AbstractStorelessUnivariateStatistic() {
    }

    @Override
    public double evaluate(double[] values) {
        SDKPreconditions.checkNotNull(values);
        return this.evaluate(values, 0, values.length);
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        if (this.test(values, begin, length)) {
            this.clear();
            this.incrementAll(values, begin, length);
        }
        return this.getResult();
    }

    @Override
    public abstract void clear();

    @Override
    public abstract double getResult();

    @Override
    public abstract void increment(double var1);

    @Override
    public void incrementAll(double[] values) {
        SDKPreconditions.checkNotNull(values);
        this.incrementAll(values, 0, values.length);
    }

    @Override
    public void incrementAll(double[] values, int begin, int length) {
        if (this.test(values, begin, length)) {
            int k = begin + length;
            for (int i = begin; i < k; ++i) {
                this.increment(values[i]);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractStorelessUnivariateStatistic)) {
            return false;
        }
        AbstractStorelessUnivariateStatistic stat = (AbstractStorelessUnivariateStatistic)object;
        return AbstractStorelessUnivariateStatistic.equalsIncludingNaN(stat.getResult(), this.getResult()) && AbstractStorelessUnivariateStatistic.equalsIncludingNaN(stat.getN(), this.getN());
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.getResult()).append(this.getN()).build();
    }

    private static boolean equalsIncludingNaN(double x, double y) {
        return x != x || y != y ? !(x != x ^ y != y) : AbstractStorelessUnivariateStatistic.equals(x, y, 1) || Math.abs(y - x) <= 1.0;
    }

    public static boolean equals(double x, double y, int maxUlps) {
        boolean isEqual;
        long yInt;
        long xInt = Double.doubleToRawLongBits(x);
        if (((xInt ^ (yInt = Double.doubleToRawLongBits(y))) & Long.MIN_VALUE) == 0L) {
            isEqual = Math.abs(xInt - yInt) <= (long)maxUlps;
        } else {
            long deltaMinus;
            long deltaPlus;
            if (xInt < yInt) {
                deltaPlus = yInt - POSITIVE_ZERO_DOUBLE_BITS;
                deltaMinus = xInt - NEGATIVE_ZERO_DOUBLE_BITS;
            } else {
                deltaPlus = xInt - POSITIVE_ZERO_DOUBLE_BITS;
                deltaMinus = yInt - NEGATIVE_ZERO_DOUBLE_BITS;
            }
            isEqual = deltaPlus > (long)maxUlps ? false : deltaMinus <= (long)maxUlps - deltaPlus;
        }
        return isEqual && !Double.isNaN(x) && !Double.isNaN(y);
    }
}

