/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.InternalProximityManagerConfiguration;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.connection.OnServiceReadyListener;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.internal.ShuffledSpacesManager;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.manager.listeners.KontaktProximityListener;
import com.kontakt.sdk.android.ble.manager.service.AbstractServiceConnector;
import com.kontakt.sdk.android.ble.monitoring.EventCollector;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.ble.service.ProximityService;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.common.interfaces.SDKSupplier;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class InternalProximityManager
extends AbstractServiceConnector {
    private static final String TAG = InternalProximityManager.class.getSimpleName();
    private static final String[] PERMISSIONS = new String[]{"android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN", "android.permission.INTERNET"};
    private static final String[] PERMISSIONS_MARSHMALLOW = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    private final int id;
    private final IKontaktCloud kontaktCloud;
    private final ShuffledSpacesManager shuffledSpacesManager;
    private FutureShufflesCache futureShufflesCache;
    private IEventCollector eventCollector;
    private Context context;
    private ServiceConnection serviceConnection;
    private Messenger serviceMessenger;
    private Messenger managerMessenger;
    private KontaktProximityListener kontaktProximityListener;
    private boolean isScanning;

    public InternalProximityManager(Context context) {
        this(context, KontaktCloud.newInstance(), InternalProximityManagerConfiguration.DEFAULT);
    }

    public InternalProximityManager(Context context, IKontaktCloud kontaktCloud, InternalProximityManagerConfiguration configuration) {
        super(context, PERMISSIONS, PERMISSIONS_MARSHMALLOW);
        this.context = context.getApplicationContext();
        this.kontaktCloud = kontaktCloud;
        this.managerMessenger = new Messenger((Handler)new ManagerHandler(this));
        this.id = System.identityHashCode(this);
        this.futureShufflesCache = new FutureShufflesCache(context, kontaktCloud, configuration);
        this.eventCollector = new EventCollector(kontaktCloud, configuration);
        this.shuffledSpacesManager = new ShuffledSpacesManager(kontaktCloud);
    }

    public int getId() {
        return this.id;
    }

    @Override
    @TargetApi(value=15)
    public synchronized void connect(final OnServiceReadyListener onServiceReadyListener) {
        SDKPreconditions.checkNotNull(onServiceReadyListener, "OnServiceBoundListener is null.");
        this.checkPermissions();
        if (this.isConnected()) {
            onServiceReadyListener.onServiceReady();
            Logger.d("InternalProximityManager already connected to BeaconService.");
            return;
        }
        this.serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder serviceBinder) {
                SDKSupplier messengerSupplier = (SDKSupplier)serviceBinder;
                InternalProximityManager.this.serviceMessenger = (Messenger)messengerSupplier.get();
                onServiceReadyListener.onServiceReady();
                Logger.d(TAG + ": Beacon Service connected.");
            }

            public void onServiceDisconnected(ComponentName name) {
                Logger.e(TAG + ": disconnected from Beacon Service");
            }
        };
        this.bindService();
    }

    @Override
    public synchronized void disconnect() {
        if (!this.isConnected()) {
            Logger.d(TAG + ": BeaconManager already disconnected.");
            return;
        }
        if (this.isScanning()) {
            this.finishScan();
        }
        try {
            if (this.serviceConnection != null) {
                Message message = this.createMessage(8, null);
                this.serviceMessenger.send(message);
                this.context.unbindService(this.serviceConnection);
                this.serviceConnection = null;
                this.serviceMessenger = null;
            }
            super.disconnect();
        }
        catch (RemoteException e) {
            Logger.e(TAG + ": unexpected exception thrown while disconnecting from Beacon Service ", e);
            throw new IllegalStateException(e);
        }
        this.eventCollector.stop();
        this.eventCollector.clear();
        this.futureShufflesCache.unregisterProximityManager(this.getId());
        this.futureShufflesCache.clearBuffers();
        this.shuffledSpacesManager.clearCache();
        this.shuffledSpacesManager.onDestroy();
        this.kontaktProximityListener = null;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.serviceConnection != null && this.serviceMessenger != null;
    }

    public synchronized void initializeScan(ScanContext scanContext, InternalProximityManagerConfiguration configuration, InternalProximityListener proximityListener) {
        SDKPreconditions.checkNotNull(scanContext, "ScanContext cannot be null");
        SDKPreconditions.checkNotNull(configuration, "InternalProximityManagerConfiguration cannot be null");
        SDKPreconditions.checkNotNull(proximityListener, "InternalProximityListener cannot be null");
        this.updateConfiguration(configuration);
        this.resolveShuffledSpaces(scanContext, proximityListener, false);
    }

    public synchronized void finishScan() {
        if (!this.isConnected()) {
            Logger.d("BeaconManger not connected");
            return;
        }
        if (!this.isScanning()) {
            Logger.d("BeaconManager is not scanning");
            return;
        }
        if (this.kontaktProximityListener != null) {
            this.kontaktProximityListener.onScanStop();
        }
        this.detachListener();
        Message message = this.createMessage(5, null);
        this.sendMessage(message);
    }

    public synchronized void restartScan(ScanContext scanContext, InternalProximityManagerConfiguration configuration, InternalProximityListener proximityListener) {
        SDKPreconditions.checkNotNull(scanContext, "ScanContext cannot be null");
        SDKPreconditions.checkNotNull(proximityListener, "InternalProximityListener cannot be null");
        this.updateConfiguration(configuration);
        this.resolveShuffledSpaces(scanContext, proximityListener, true);
    }

    public synchronized boolean isScanning() {
        return this.isScanning;
    }

    public synchronized void clearCache() {
        this.futureShufflesCache.clear();
        this.eventCollector.clear();
    }

    public synchronized void clearBuffers() {
        this.futureShufflesCache.clearBuffers();
        this.eventCollector.clear();
    }

    private synchronized void attachListener(InternalProximityListener proximityListener) {
        SDKPreconditions.checkNotNull(proximityListener, "Proximity listener is null");
        if (this.kontaktProximityListener == null) {
            this.kontaktProximityListener = new KontaktProximityListener(this.getId(), proximityListener, this.futureShufflesCache, this.eventCollector);
            this.futureShufflesCache.registerProximityManager(this.getId());
            this.futureShufflesCache.addProximityListener(this.kontaktProximityListener);
        }
        Message message = this.createMessage(6, this.kontaktProximityListener);
        this.sendMessage(message);
    }

    private synchronized void detachListener() {
        if (this.kontaktProximityListener == null) {
            return;
        }
        this.futureShufflesCache.removeProximityListener(this.kontaktProximityListener);
        Message message = this.createMessage(7, this.kontaktProximityListener);
        this.kontaktProximityListener = null;
        this.sendMessage(message);
    }

    private void bindService() {
        Intent serviceIntent = new Intent(this.context, ProximityService.class);
        boolean isBindRequestSent = this.context.bindService(serviceIntent, this.serviceConnection, 1);
        if (!isBindRequestSent) {
            String serviceName = ProximityService.class.getSimpleName();
            throw new RuntimeException(String.format("Could not connect to %s. Please check if the %s is registered in AndroidManifest.xml", serviceName, serviceName));
        }
    }

    private void updateConfiguration(InternalProximityManagerConfiguration configuration) {
        this.eventCollector.updateConfiguration(configuration);
        if (this.kontaktProximityListener != null) {
            this.futureShufflesCache.removeProximityListener(this.kontaktProximityListener);
        }
        this.futureShufflesCache.unregisterProximityManager(this.getId());
        this.futureShufflesCache = new FutureShufflesCache(this.context, this.kontaktCloud, configuration);
    }

    private void resolveShuffledSpaces(ScanContext scanContext, final InternalProximityListener proximityListener, final boolean restartScan) {
        this.shuffledSpacesManager.resolve(scanContext, new ShuffledSpacesManager.OnSpacesResolvedListener(){

            @Override
            public void onSpacesResolved(ScanContext scanContext) {
                InternalProximityManager.this.startScanIfConnected(scanContext, restartScan, proximityListener);
            }

            @Override
            public void onError(ScanError exception) {
                proximityListener.onScanError(exception);
            }
        });
    }

    private void startScanIfConnected(ScanContext scanContext, boolean restartScan, InternalProximityListener proximityListener) {
        if (this.isScanning() && !restartScan) {
            Logger.d(TAG + ": BeaconManager is already scanning");
            return;
        }
        this.futureShufflesCache.registerProximityManager(this.getId());
        this.eventCollector.start();
        int messageCode = restartScan ? 3 : 4;
        Message message = this.createMessage(messageCode, scanContext);
        this.sendMessage(message);
        this.attachListener(proximityListener);
        proximityListener.onScanStart();
    }

    private boolean sendMessage(Message message) {
        if (this.isConnected()) {
            try {
                this.serviceMessenger.send(message);
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }
        Logger.i("BeaconManager already disconnected");
        return false;
    }

    private Message createMessage(int messageCode, Object obj) {
        Message message = Message.obtain(null, (int)messageCode, (int)this.id, (int)-1, (Object)obj);
        message.replyTo = this.managerMessenger;
        return message;
    }

    private static class ManagerHandler
    extends Handler {
        private final InternalProximityManager manager;

        private ManagerHandler(InternalProximityManager manager) {
            this.manager = manager;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: 
                case 4: {
                    this.manager.isScanning = msg.arg1 == 201;
                    break;
                }
                case 5: 
                case 8: {
                    this.manager.isScanning = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported response code: " + msg.what);
                }
            }
        }
    }
}

