/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.ibeacon;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.util.SparseArray;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.device.BeaconDevice;
import com.kontakt.sdk.android.ble.discovery.AbstractBluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.Validator;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconAdvertisingDataController;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconAdvertisingPacket;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.ibeacon.RegionValidator;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import java.util.ArrayList;

@TargetApi(value=18)
public class IBeaconDiscoverer
extends AbstractBluetoothDeviceDiscoverer<IBeaconRegion, IBeaconDevice> {
    private final IBeaconAdvertisingDataController advertisingDataController;
    private final Validator<IBeaconAdvertisingPacket, IBeaconRegion> validator;

    public IBeaconDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract) {
        super(discoveryContract, scanContext.getIBeaconScanContext().getDistanceSort(), scanContext.getIBeaconScanContext().getEventTypes(), scanContext.getActivityCheckConfiguration(), scanContext.getIBeaconScanContext().getSpaces(), scanContext.getDevicesUpdateCallbackInterval());
        this.advertisingDataController = new IBeaconAdvertisingDataController(scanContext);
        this.validator = new RegionValidator();
    }

    @Override
    protected BluetoothDeviceEvent createEvent(EventType eventType, IBeaconRegion iBeaconRegion, ArrayList<IBeaconDevice> deviceList) {
        return new IBeaconDeviceEvent(eventType, iBeaconRegion, deviceList);
    }

    @Override
    protected void onBeforeDeviceLost(IBeaconDevice device) {
        this.advertisingDataController.clearRssiCalculation(device.hashCode());
    }

    @Override
    public boolean performDiscovery(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (!this.advertisingDataController.isEnabled()) {
            Logger.d("AdvertisingDataController not enabled.");
            return PROFILE_UNRECOGNIZED;
        }
        SparseArray<byte[]> parsedScan = IBeaconAdvertisingDataController.parseScanRecord(scanRecord);
        if (parsedScan == null) {
            return PROFILE_UNRECOGNIZED;
        }
        IBeaconAdvertisingPacket advertisingPacket = this.advertisingDataController.getOrCreateAdvertisingPackage(device, rssi, parsedScan);
        if (advertisingPacket == null) {
            return PROFILE_UNRECOGNIZED;
        }
        IBeaconRegion iBeaconRegion = this.extractRegion(advertisingPacket);
        if (iBeaconRegion == null) {
            return PROFILE_RECOGNIZED_NO_BELONGING_SPACE_FOUND;
        }
        if (advertisingPacket.getProximity() != Proximity.UNKNOWN && this.advertisingDataController.filter(advertisingPacket)) {
            this.notifySpacePresent(iBeaconRegion.hashCode(), System.currentTimeMillis());
            ReplacingArrayList<Object> iBeaconList = this.getDevicesInSpace(iBeaconRegion);
            if (iBeaconList == null) {
                iBeaconList = new ReplacingArrayList();
                this.insertDevicesIntoSpace(iBeaconRegion, iBeaconList);
                this.onSpaceEnteredEvent(iBeaconRegion);
                return true;
            }
            BeaconDevice discoveredDevice = new BeaconDevice(advertisingPacket);
            if (iBeaconList.addOrReplace(discoveredDevice)) {
                this.onDeviceDiscoveredEvent(iBeaconRegion, discoveredDevice);
            } else {
                this.sortIfEnabled(iBeaconList);
                this.onDevicesUpdatedEvent(iBeaconRegion, iBeaconList);
            }
            return true;
        }
        return PROFILE_RECOGNIZED_FILTERING_NOT_PASSED;
    }

    @Override
    public void disable() {
        this.advertisingDataController.disable();
    }

    private IBeaconRegion extractRegion(IBeaconAdvertisingPacket advertisingPacket) {
        for (IBeaconRegion iBeaconRegion : this.getSpaceSet()) {
            if (!this.validator.isValid(advertisingPacket, iBeaconRegion)) continue;
            return iBeaconRegion;
        }
        return null;
    }
}

