/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.discovery.eddystone.EddystonePropertyResolver;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class InstanceIdResolver
implements EddystonePropertyResolver<String> {
    static final int INSTANCE_ID_START_INDEX = 23;
    private static final int SCAN_RECORD_INSTANCE_ID_LENGTH = 6;
    private static final int MASK = 255;
    private final StringBuilder instanceIdBuilder = new StringBuilder();
    private static final String FORMAT = "%02x";

    InstanceIdResolver() {
    }

    @Override
    public byte[] extract(byte[] scanRecord) {
        return ConversionUtils.extractPayload(scanRecord, 23, 6);
    }

    @Override
    public String parse(byte[] source) {
        if (source == null) {
            return null;
        }
        this.instanceIdBuilder.setLength(0);
        for (byte byteValue : source) {
            this.instanceIdBuilder.append(String.format(FORMAT, byteValue & 0xFF));
        }
        return this.instanceIdBuilder.toString();
    }
}

