/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.ble.discovery.DiscoveryUtils;
import java.util.Arrays;

public final class ScanResponse {
    public static final ScanResponse UNKNOWN = new ScanResponse("", -1, "-1", false, new byte[0]);
    public static final int TYPE_SERVICE_DATA = 22;
    private static final int KONTAKT_DEVICE_SCAN_RESPONSE_MIN_LENGTH = 9;
    public static final byte PAYLOAD_VERSION_1 = 1;
    private final String uniqueId;
    private final int batteryPercentagePower;
    private final String firmwareVersion;
    private final boolean shuffled;
    private final byte[] bytes;

    private ScanResponse(String uniqueId, int batteryPercentagePower, String firmwareVersion, boolean shuffled, byte[] bytes) {
        this.uniqueId = uniqueId;
        this.batteryPercentagePower = batteryPercentagePower;
        this.firmwareVersion = firmwareVersion;
        this.shuffled = shuffled;
        this.bytes = bytes;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public int getBatteryPower() {
        return this.batteryPercentagePower;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean isShuffled() {
        return this.shuffled;
    }

    public static ScanResponse fromScanRecordBytes(byte[] scanRecord) {
        return scanRecord != null ? ScanResponse.fromScanResponseBytes(DiscoveryUtils.extractDataByType(22, scanRecord)) : UNKNOWN;
    }

    public static ScanResponse fromScanResponseBytes(byte[] scanResponse) {
        boolean isShuffled;
        if (scanResponse == null || scanResponse.length < 9) {
            return UNKNOWN;
        }
        String uniqueId = null;
        String firmware = null;
        int batteryPercentagePower = 0;
        byte payloadVersion = scanResponse[2];
        boolean bl = isShuffled = payloadVersion == 1;
        if (isShuffled) {
            firmware = ScanResponse.parseShuffledFirmwareVersion(scanResponse);
            batteryPercentagePower = ScanResponse.extractShuffledBatteryPercentagePower(scanResponse);
        } else {
            uniqueId = ScanResponse.parseUniqueId(scanResponse);
            firmware = ScanResponse.parseFirmwareVersion(scanResponse);
            batteryPercentagePower = ScanResponse.extractBatteryPercentagePower(scanResponse);
        }
        return new ScanResponse(uniqueId, batteryPercentagePower, firmware, isShuffled, scanResponse);
    }

    private static String parseShuffledFirmwareVersion(byte[] serviceData) {
        if (serviceData != null) {
            char firmwareVersionMajor = (char)(serviceData[23] & 0xFF);
            char firmwareVersionMinor = (char)(serviceData[24] & 0xFF);
            return String.format("%c.%c", Character.valueOf(firmwareVersionMajor), Character.valueOf(firmwareVersionMinor));
        }
        return "-1";
    }

    private static String parseFirmwareVersion(byte[] serviceData) {
        if (serviceData != null) {
            char firmwareVersionMajor = (char)(serviceData[6] & 0xFF);
            char firmwareVersionMinor = (char)(serviceData[7] & 0xFF);
            return String.format("%c.%c", Character.valueOf(firmwareVersionMajor), Character.valueOf(firmwareVersionMinor));
        }
        return "-1";
    }

    private static int extractBatteryPercentagePower(byte[] serviceData) {
        return serviceData != null ? serviceData[8] : -1;
    }

    private static int extractShuffledBatteryPercentagePower(byte[] serviceData) {
        return serviceData != null ? serviceData[25] : -1;
    }

    private static String parseUniqueId(byte[] serviceData) {
        return serviceData != null ? new String(Arrays.copyOfRange(serviceData, 2, 6)) : "";
    }
}

