/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import android.util.SparseArray;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.Arrays;

public final class DiscoveryUtils {
    private DiscoveryUtils() {
    }

    public static double calculateDistance(int txPower, double rssi) {
        if (rssi == 0.0) {
            return -1.0;
        }
        double ratio = rssi * 1.0 / (double)txPower;
        if (ratio < 1.0) {
            return Math.pow(ratio, 10.0);
        }
        double accuracy = 0.89976 * Math.pow(ratio, 7.7095) + 0.111;
        return accuracy;
    }

    public static byte[] extractDataByType(int type, byte[] scanRecord) {
        return (byte[])DiscoveryUtils.extractMetaData(scanRecord).get(type);
    }

    public static SparseArray<byte[]> extractMetaData(byte[] scanRecord) {
        int type;
        byte length;
        int index = 0;
        SparseArray map = new SparseArray();
        int scanRecordLength = scanRecord.length;
        while (index < scanRecordLength && (length = scanRecord[index++]) != 0 && (type = ConversionUtils.asInt(scanRecord[index])) != 0) {
            byte[] data = Arrays.copyOfRange(scanRecord, index + 1, index + length);
            map.put(type, (Object)data);
            index += length;
        }
        return map;
    }
}

