/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import android.annotation.TargetApi;
import android.util.SparseLongArray;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.DistanceSort;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.ble.util.SafeSparseLongArray;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractBluetoothDeviceDiscoverer<Space, RBD extends RemoteBluetoothDevice>
implements BluetoothDeviceDiscoverer {
    protected static boolean PROFILE_UNRECOGNIZED = false;
    protected static boolean PROFILE_RECOGNIZED_DEVICE_NOT_READY = true;
    protected static boolean PROFILE_RECOGNIZED_FILTERING_NOT_PASSED = true;
    protected static boolean PROFILE_RECOGNIZED_NO_BELONGING_SPACE_FOUND = true;
    private final ArrayList<RBD> EMPTY_DEVICE_LIST = new ArrayList();
    private final DistanceComparator distanceComparator;
    private final DiscoveryContract discoveryContract;
    private final Collection<EventType> eventTypes;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final Collection<Space> spaceSet;
    private final Map<Space, ReplacingArrayList<RBD>> spaceDeviceListMap = new ConcurrentHashMap<Space, ReplacingArrayList<RBD>>();
    private final SparseLongArray spaceTimestampArray;
    private final long devicesUpdateCallbackInterval;
    private long lastCallbackTime = 0L;

    protected abstract BluetoothDeviceEvent createEvent(EventType var1, Space var2, ArrayList<RBD> var3);

    protected abstract void onBeforeDeviceLost(RBD var1);

    protected AbstractBluetoothDeviceDiscoverer(DiscoveryContract discoveryContract, DistanceSort distanceSort, Collection<EventType> eventTypes, ActivityCheckConfiguration activityCheckConfiguration, Collection<Space> spaceSet, long deviceUpdateCallbackInterval) {
        this.discoveryContract = discoveryContract;
        this.distanceComparator = new DistanceComparator(distanceSort);
        this.eventTypes = eventTypes;
        this.activityCheckConfiguration = activityCheckConfiguration;
        this.spaceSet = spaceSet;
        this.devicesUpdateCallbackInterval = deviceUpdateCallbackInterval;
        this.spaceTimestampArray = new SafeSparseLongArray(spaceSet.size());
    }

    @Override
    @TargetApi(value=18)
    public void clearResources() {
        this.spaceTimestampArray.clear();
        this.spaceDeviceListMap.clear();
    }

    protected void sortIfEnabled(List<RBD> deviceList) {
        this.distanceComparator.sort(deviceList);
    }

    @TargetApi(value=18)
    protected void notifySpacePresent(int spaceHashcode, long timestamp) {
        this.spaceTimestampArray.put(spaceHashcode, timestamp);
    }

    protected Collection<Space> getSpaceSet() {
        return this.spaceSet;
    }

    protected ReplacingArrayList<RBD> getDevicesInSpace(Space space) {
        return this.spaceDeviceListMap.get(space);
    }

    protected void insertDevicesIntoSpace(Space space, ReplacingArrayList<RBD> deviceList) {
        this.spaceDeviceListMap.put(space, deviceList);
    }

    protected void onSpaceEnteredEvent(Space space) {
        EventType spaceEntered = EventType.SPACE_ENTERED;
        if (this.eventTypes.contains((Object)spaceEntered)) {
            this.discoveryContract.onEvent(this.createEvent(spaceEntered, space, this.EMPTY_DEVICE_LIST));
        }
    }

    protected void onDeviceDiscoveredEvent(Space space, RBD device) {
        EventType deviceDiscovered = EventType.DEVICE_DISCOVERED;
        if (this.eventTypes.contains((Object)deviceDiscovered)) {
            ArrayList<RBD> deviceList = new ArrayList<RBD>(1);
            deviceList.add(device);
            this.discoveryContract.onEvent(this.createEvent(EventType.DEVICE_DISCOVERED, space, deviceList));
        }
    }

    protected void onDevicesUpdatedEvent(Space space, Collection<RBD> deviceList) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lastCallbackTime + this.devicesUpdateCallbackInterval > currentTimeMillis) {
            return;
        }
        EventType devicesUpdate = EventType.DEVICES_UPDATE;
        if (this.eventTypes.contains((Object)devicesUpdate)) {
            this.discoveryContract.onEvent(this.createEvent(devicesUpdate, space, new ArrayList<RBD>(deviceList)));
        }
        this.lastCallbackTime = currentTimeMillis;
    }

    protected void onDeviceLostEvent(Space space, RBD device) {
        EventType deviceLost = EventType.DEVICE_LOST;
        if (this.eventTypes.contains((Object)deviceLost)) {
            ArrayList<RBD> deviceList = new ArrayList<RBD>(1);
            deviceList.add(device);
            this.discoveryContract.onEvent(this.createEvent(deviceLost, space, deviceList));
        }
    }

    protected void onSpaceAbandonedEvent(Space space) {
        EventType eventType = EventType.SPACE_ABANDONED;
        if (this.eventTypes.contains((Object)eventType)) {
            this.discoveryContract.onEvent(this.createEvent(eventType, space, this.EMPTY_DEVICE_LIST));
        }
    }

    @Override
    public void evictInactiveDevices() {
        long beaconInactivityTimeout = this.activityCheckConfiguration.getInactivityTimeout();
        for (Map.Entry<Space, ReplacingArrayList<RBD>> entry : this.spaceDeviceListMap.entrySet()) {
            Space space = entry.getKey();
            Iterator iBeaconIterator = entry.getValue().iterator();
            while (iBeaconIterator.hasNext()) {
                RemoteBluetoothDevice remoteDevice = (RemoteBluetoothDevice)iBeaconIterator.next();
                long threshold = System.currentTimeMillis() - remoteDevice.getTimestamp();
                if (threshold <= beaconInactivityTimeout) continue;
                iBeaconIterator.remove();
                this.onBeforeDeviceLost(remoteDevice);
                this.onDeviceLostEvent(space, remoteDevice);
            }
        }
        this.evictInactiveRegions();
    }

    @Override
    public void reset() {
        this.spaceDeviceListMap.clear();
    }

    @TargetApi(value=18)
    private void evictInactiveRegions() {
        HashSet<Space> spaces = new HashSet<Space>(this.spaceDeviceListMap.keySet());
        long beaconInactivityTimeout = this.activityCheckConfiguration.getInactivityTimeout();
        for (Object space : spaces) {
            long timestampDifference;
            int regionHashCode = space.hashCode();
            long regionTimestamp = this.spaceTimestampArray.get(regionHashCode, -1L);
            if (regionTimestamp == -1L || (timestampDifference = System.currentTimeMillis() - regionTimestamp) <= beaconInactivityTimeout) continue;
            this.spaceTimestampArray.get(regionHashCode, -1L);
            this.spaceDeviceListMap.remove(space);
            this.onSpaceAbandonedEvent(space);
        }
    }

    private static class DistanceComparator
    implements Comparator<RemoteBluetoothDevice> {
        private final int sortFactor;

        private DistanceComparator(DistanceSort distanceSort) {
            switch (distanceSort) {
                case DESC: {
                    this.sortFactor = -1;
                    break;
                }
                case ASC: {
                    this.sortFactor = 1;
                    break;
                }
                default: {
                    this.sortFactor = 0;
                }
            }
        }

        private boolean isEnabled() {
            return this.sortFactor != 0;
        }

        private void sort(List<? extends RemoteBluetoothDevice> devices) {
            if (this.isEnabled()) {
                Collections.sort(devices, this);
            }
        }

        @Override
        public int compare(RemoteBluetoothDevice lhs, RemoteBluetoothDevice rhs) {
            int sortResult = lhs.getDistance() < rhs.getDistance() ? -1 : 1;
            return sortResult * this.sortFactor;
        }
    }
}

