/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;

public class EddystoneNamespace
implements IEddystoneNamespace {
    public static EddystoneNamespace EVERYWHERE = new EddystoneNamespace("Everywhere", "", false);
    public static final Parcelable.Creator<EddystoneNamespace> CREATOR = new Parcelable.Creator<EddystoneNamespace>(){

        public EddystoneNamespace createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            return new EddystoneNamespace(bundle.getString("name"), bundle.getString("url"), bundle.getBoolean("isShuffled"));
        }

        public EddystoneNamespace[] newArray(int size) {
            return new EddystoneNamespace[size];
        }
    };
    private final String name;
    private final String namespace;
    private final boolean isShuffled;
    private final int hashCode;

    public static EddystoneNamespace create(String name, String namespace, boolean isShuffled) {
        return new EddystoneNamespace(name, namespace, isShuffled);
    }

    private EddystoneNamespace(String name, String namespace, boolean isShuffled) {
        this.namespace = namespace;
        this.name = name;
        this.isShuffled = isShuffled;
        this.hashCode = namespace.hashCode();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isShuffled() {
        return this.isShuffled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EddystoneNamespace)) {
            return false;
        }
        EddystoneNamespace eddystoneNamespace = (EddystoneNamespace)o;
        return this.namespace.equals(eddystoneNamespace.namespace);
    }

    @Override
    public int compareTo(IEddystoneNamespace another) {
        if (this == another) {
            return 0;
        }
        return this.namespace.compareTo(another.getNamespace());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString("url", this.namespace);
        bundle.putString("name", this.name);
        bundle.putBoolean("isShuffled", this.isShuffled);
        parcel.writeBundle(bundle);
    }
}

