/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneTLMAdvertisingPacket;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneUIDAdvertisingPacket;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneURLAdvertisingPacket;
import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;

public class EddystoneDevice
implements IEddystoneDevice {
    public static final Parcelable.Creator<EddystoneDevice> CREATOR = new Parcelable.Creator<EddystoneDevice>(){

        public EddystoneDevice createFromParcel(Parcel source) {
            return new EddystoneDevice(source);
        }

        public EddystoneDevice[] newArray(int size) {
            return new EddystoneDevice[size];
        }
    };
    private final long timestamp;
    private final String namespaceId;
    private final String instanceId;
    private final int txPower;
    private final String url;
    private final int hashCode;
    private final double distance;
    private final String address;
    private final Proximity proximity;
    private final double rssi;
    private final Telemetry telemetry;
    private final String firmwareVersion;
    private final String uniqueId;
    private final int batteryPower;
    private final String name;
    private byte[] password;
    private final boolean shuffled;

    private EddystoneDevice(Parcel source) {
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        this.name = bundle.getString("name");
        this.timestamp = bundle.getLong("timestamp");
        this.namespaceId = bundle.getString("namespaceId");
        this.instanceId = bundle.getString("instanceId");
        this.txPower = bundle.getInt("txPower");
        this.url = bundle.getString("url");
        this.distance = bundle.getDouble("accuracy");
        this.address = bundle.getString("address");
        this.proximity = (Proximity)((Object)bundle.getSerializable("proximity"));
        this.rssi = bundle.getDouble("rssi");
        this.telemetry = (Telemetry)bundle.getParcelable("telemetry");
        this.password = bundle.getByteArray("password");
        this.firmwareVersion = bundle.getString("firmware");
        this.uniqueId = bundle.getString("uniqueId");
        this.batteryPower = bundle.getInt("battery");
        this.shuffled = bundle.getBoolean("shuffled");
        this.hashCode = HashCodeBuilder.init().append(this.namespaceId).append(this.instanceId).append(this.txPower).append(this.url).build();
    }

    private EddystoneDevice(Builder builder) {
        this.name = builder.name;
        this.timestamp = builder.timestamp;
        this.namespaceId = builder.namespaceId;
        this.instanceId = builder.instanceId;
        this.txPower = builder.txPower;
        this.url = builder.url;
        this.distance = builder.distance;
        this.address = builder.address;
        this.proximity = builder.proximity;
        this.rssi = builder.rssi;
        this.telemetry = builder.telemetry;
        this.firmwareVersion = builder.firmwareVersion;
        this.uniqueId = builder.uniqueId;
        this.batteryPower = builder.batteryPower;
        this.shuffled = builder.shuffled;
        this.hashCode = HashCodeBuilder.init().append(this.address).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EddystoneDevice)) {
            return false;
        }
        EddystoneDevice device = (EddystoneDevice)o;
        return TextUtils.equals((CharSequence)this.address, (CharSequence)device.address);
    }

    @Override
    public int compareTo(IEddystoneDevice another) {
        if (this == another) {
            return 0;
        }
        int namespaceComparisonResult = this.namespaceId.compareTo(another.getNamespaceId());
        if (namespaceComparisonResult == 0) {
            int instanceComparisonResult = this.instanceId.compareTo(another.getInstanceId());
            if (instanceComparisonResult == 0) {
                return this.url.compareTo(another.getUrl());
            }
            return instanceComparisonResult;
        }
        return namespaceComparisonResult;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putString("namespaceId", this.namespaceId);
        bundle.putString("instanceId", this.instanceId);
        bundle.putString("url", this.url);
        bundle.putInt("txPower", this.txPower);
        bundle.putLong("timestamp", this.timestamp);
        bundle.putDouble("accuracy", this.distance);
        bundle.putSerializable("proximity", (Serializable)((Object)this.proximity));
        bundle.putDouble("rssi", this.rssi);
        bundle.putString("address", this.address);
        bundle.putParcelable("telemetry", (Parcelable)this.telemetry);
        bundle.putByteArray("password", this.password);
        bundle.putString("name", this.name);
        bundle.putString("firmware", this.firmwareVersion);
        bundle.putString("uniqueId", this.uniqueId);
        bundle.putInt("battery", this.batteryPower);
        bundle.putBoolean("shuffled", this.shuffled);
        dest.writeBundle(bundle);
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public Proximity getProximity() {
        return this.proximity;
    }

    @Override
    public double getRssi() {
        return this.rssi;
    }

    @Override
    public void setPassword(byte[] password) {
        SDKPreconditions.checkNotNull(password, "Password is null");
        int passwordLength = password.length;
        this.password = new byte[passwordLength];
        System.arraycopy(password, 0, this.password, 0, passwordLength);
    }

    @Override
    public byte[] getPassword() {
        return this.password;
    }

    @Override
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public int getBatteryPower() {
        return this.batteryPower;
    }

    @Override
    public String getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public int getTxPower() {
        return this.txPower;
    }

    @Override
    public DeviceProfile getProfile() {
        return DeviceProfile.EDDYSTONE;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public int getBatteryVoltage() {
        return this.telemetry.getBatteryVoltage();
    }

    @Override
    public double getTemperature() {
        return this.telemetry.getTemperature();
    }

    @Override
    public int getPduCount() {
        return this.telemetry.getPduCount();
    }

    @Override
    public int getTimeSincePowerUp() {
        return this.telemetry.getTimeSincePowerUp();
    }

    @Override
    public int getTelemetryVersion() {
        return this.telemetry.getVersion();
    }

    @Override
    public boolean isShuffled() {
        return this.shuffled;
    }

    public static class Builder {
        private String namespaceId;
        private String instanceId;
        private int txPower;
        private String url;
        private double distance;
        private String address;
        private Proximity proximity;
        private double rssi;
        private Telemetry telemetry;
        private long timestamp;
        private String firmwareVersion;
        private String uniqueId;
        private int batteryPower;
        private String name;
        private boolean shuffled;

        public EddystoneDevice build() {
            return new EddystoneDevice(this);
        }

        public Builder setEddystoneDevice(IEddystoneDevice eddystoneDevice) {
            this.name = eddystoneDevice.getName();
            this.timestamp = eddystoneDevice.getTimestamp();
            this.namespaceId = eddystoneDevice.getNamespaceId();
            this.instanceId = eddystoneDevice.getInstanceId();
            this.txPower = eddystoneDevice.getTxPower();
            this.url = eddystoneDevice.getUrl();
            this.distance = eddystoneDevice.getDistance();
            this.address = eddystoneDevice.getAddress();
            this.proximity = eddystoneDevice.getProximity();
            this.rssi = eddystoneDevice.getRssi();
            this.telemetry = new Telemetry.Builder().setBatteryVoltage(eddystoneDevice.getBatteryVoltage()).setTemperature(eddystoneDevice.getTemperature()).setPduCount(eddystoneDevice.getPduCount()).setTimeSincePowerUp(eddystoneDevice.getTimeSincePowerUp()).setVersion(eddystoneDevice.getTelemetryVersion()).build();
            this.firmwareVersion = eddystoneDevice.getFirmwareVersion();
            this.uniqueId = eddystoneDevice.getUniqueId();
            this.batteryPower = eddystoneDevice.getBatteryPower();
            this.shuffled = eddystoneDevice.isShuffled();
            return this;
        }

        public Builder setResolvedId(ResolvedId resolvedId) {
            EddystoneUid eddystoneUID = resolvedId.getEddystoneUID();
            this.namespaceId = eddystoneUID.getNamespace();
            this.instanceId = eddystoneUID.getInstanceId();
            this.uniqueId = resolvedId.getUniqueId();
            return this;
        }

        public Builder setUIDAdvertisingPacket(EddystoneUIDAdvertisingPacket uidPacket) {
            this.namespaceId = uidPacket != null ? uidPacket.getNamespaceId() : null;
            this.instanceId = uidPacket != null ? uidPacket.getInstanceId() : null;
            return this;
        }

        public Builder setURLAdvertisingPacket(EddystoneURLAdvertisingPacket urlPacket) {
            this.url = urlPacket != null ? urlPacket.getUrl() : null;
            return this;
        }

        public Builder setTLMAdvertisingPacket(EddystoneTLMAdvertisingPacket tlmPacket) {
            this.telemetry = new Telemetry.Builder().setBatteryVoltage(tlmPacket != null ? tlmPacket.getBatteryVoltage() : 0).setTimeSincePowerUp(tlmPacket != null ? tlmPacket.getTimeSincePowerUp() : 0).setTemperature(tlmPacket != null ? tlmPacket.getTemperature() : 0.0).setPduCount(tlmPacket != null ? tlmPacket.getPduCount() : 0).setVersion(tlmPacket != null ? tlmPacket.getTelemetryVersion() : -1).build();
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.txPower = txPower;
            return this;
        }

        public Builder setDistance(double distance) {
            this.distance = distance;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setProximity(Proximity proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder setRssi(double rssi) {
            this.rssi = rssi;
            return this;
        }

        public Builder setFirmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        public Builder setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder setBatteryPower(int batteryPower) {
            this.batteryPower = batteryPower;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setShuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }
    }
}

