/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.ble.connection.SyncableKontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.common.model.Device;

class InternalBeaconWriteListener
implements WriteListener {
    private SyncableKontaktDeviceConnection.SyncWriteListener syncWriteListener;
    private Device device;
    private IKontaktCloud kontaktCloud;

    public InternalBeaconWriteListener(IKontaktCloud kontaktCloud, SyncableKontaktDeviceConnection.SyncWriteListener syncWriteListener, Device device) {
        this.kontaktCloud = kontaktCloud;
        this.syncWriteListener = syncWriteListener;
        this.device = device;
    }

    @Override
    public void onWriteSuccess(WriteListener.WriteResponse response) {
        if (this.device == null) {
            int errorCode = -1;
            this.syncWriteListener.onSyncFailed(new KontaktCloudException("cannot update device - empty data", errorCode));
            return;
        }
        this.kontaktCloud.devices().update(this.device.getUniqueId()).with(this.device).execute(new CloudCallback<String>(){

            @Override
            public void onSuccess(String response, CloudHeaders headers) {
                InternalBeaconWriteListener.this.syncWriteListener.onSuccess();
            }

            @Override
            public void onError(CloudError error) {
                InternalBeaconWriteListener.this.syncWriteListener.onSyncFailed(error);
            }
        });
    }

    @Override
    public void onWriteFailure(WriteListener.Cause cause) {
        if (this.syncWriteListener != null) {
            this.syncWriteListener.onWriteFailed(cause);
        }
    }
}

