/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration.scan;

import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.GlobalScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.IBeaconScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContextValidator;
import com.kontakt.sdk.android.ble.configuration.scan.ScanMode;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.ble.rssi.RssiCalculators;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public final class ScanContext
implements GlobalScanContext {
    public static final long DEFAULT_DEVICES_UPDATE_CALLBACK_INTERVAL = 3000L;
    public static final ScanContext DEFAULT = new Builder().setForceScanConfiguration(ForceScanConfiguration.DISABLED).setScanMode(ScanMode.BALANCED).setActivityCheckConfiguration(ActivityCheckConfiguration.MINIMAL).setEddystoneScanContext(EddystoneScanContext.DEFAULT).setIBeaconScanContext(IBeaconScanContext.DEFAULT).setDevicesUpdateCallbackInterval(3000L).setScanPeriod(ScanPeriod.RANGING).setRssiCalculator(RssiCalculators.DEFAULT).build();
    private final ForceScanConfiguration forceScanConfiguration;
    private final ScanPeriod scanPeriod;
    private final ScanMode scanMode;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final long devicesUpdateCallbackInterval;
    private final RssiCalculator rssiCalculator;
    private final IBeaconScanContext iBeaconScanContext;
    private final EddystoneScanContext eddystoneScanContext;

    private ScanContext(Builder builder) {
        this.forceScanConfiguration = builder.forceScanConfiguration;
        this.scanPeriod = builder.scanPeriod;
        this.scanMode = builder.scanMode;
        this.activityCheckConfiguration = builder.activityCheckConfiguration;
        this.iBeaconScanContext = builder.iBeaconScanContext;
        this.eddystoneScanContext = builder.eddystoneScanContext;
        this.devicesUpdateCallbackInterval = builder.devicesUpdateCallbackInterval;
        this.rssiCalculator = builder.rssiCalculator;
    }

    @Override
    public ActivityCheckConfiguration getActivityCheckConfiguration() {
        return this.activityCheckConfiguration;
    }

    @Override
    public IBeaconScanContext getIBeaconScanContext() {
        return this.iBeaconScanContext;
    }

    @Override
    public EddystoneScanContext getEddystoneScanContext() {
        return this.eddystoneScanContext;
    }

    @Override
    public ForceScanConfiguration getForceScanConfiguration() {
        return this.forceScanConfiguration;
    }

    @Override
    public ScanPeriod getScanPeriod() {
        return this.scanPeriod;
    }

    @Override
    public ScanMode getScanMode() {
        return this.scanMode;
    }

    @Override
    public long getDevicesUpdateCallbackInterval() {
        return this.devicesUpdateCallbackInterval;
    }

    @Override
    public RssiCalculator getRssiCalculator() {
        return this.rssiCalculator;
    }

    public static final class Builder {
        private ScanMode scanMode = ScanMode.BALANCED;
        private ForceScanConfiguration forceScanConfiguration = ForceScanConfiguration.DISABLED;
        private ScanPeriod scanPeriod = ScanPeriod.RANGING;
        private ActivityCheckConfiguration activityCheckConfiguration = ActivityCheckConfiguration.MINIMAL;
        private long devicesUpdateCallbackInterval = 3000L;
        private RssiCalculator rssiCalculator = RssiCalculators.DEFAULT;
        private IBeaconScanContext iBeaconScanContext;
        private EddystoneScanContext eddystoneScanContext;

        public Builder setIBeaconScanContext(IBeaconScanContext iBeaconScanContext) {
            this.iBeaconScanContext = iBeaconScanContext;
            return this;
        }

        public Builder setEddystoneScanContext(EddystoneScanContext eddystoneScanContext) {
            this.eddystoneScanContext = eddystoneScanContext;
            return this;
        }

        public Builder setActivityCheckConfiguration(ActivityCheckConfiguration activityCheckConfiguration) {
            SDKPreconditions.checkNotNull(activityCheckConfiguration, "Beacon activity check is null.");
            this.activityCheckConfiguration = activityCheckConfiguration;
            return this;
        }

        public Builder setScanMode(ScanMode scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        public Builder setForceScanConfiguration(ForceScanConfiguration forceScanConfiguration) {
            SDKPreconditions.checkNotNull(forceScanConfiguration, "By default ForceScanConfiguration is disabled");
            this.forceScanConfiguration = forceScanConfiguration;
            return this;
        }

        public Builder setScanPeriod(ScanPeriod scanPeriod) {
            SDKPreconditions.checkNotNull(scanPeriod, "Monitor period cannot be null");
            ScanContextValidator.validate(scanPeriod);
            this.scanPeriod = scanPeriod;
            return this;
        }

        public Builder setDevicesUpdateCallbackInterval(long intervalInMillis) {
            SDKPreconditions.checkArgument(intervalInMillis > 0L, "Interval must be greater than 0");
            this.devicesUpdateCallbackInterval = intervalInMillis;
            return this;
        }

        public Builder setRssiCalculator(RssiCalculator rssiCalculator) {
            SDKPreconditions.checkNotNull(rssiCalculator, "RssiCalculator can't be null");
            this.rssiCalculator = rssiCalculator;
            return this;
        }

        public ScanContext build() {
            if (this.activityCheckConfiguration != ActivityCheckConfiguration.DISABLED) {
                ScanContextValidator.validate(this.activityCheckConfiguration);
            }
            if (this.forceScanConfiguration != ForceScanConfiguration.DISABLED) {
                ScanContextValidator.validate(this.forceScanConfiguration);
            }
            String message = "At least one of: [IBeaconScanContext, EddystoneScanContext] must be set";
            SDKPreconditions.checkNotAllNull(new IllegalStateException(message), this.iBeaconScanContext, this.eddystoneScanContext);
            return new ScanContext(this);
        }
    }
}

