/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration.scan;

import com.kontakt.sdk.android.ble.configuration.scan.AbstractProfileSpecificScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContextValidator;
import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class IBeaconScanContext
extends AbstractProfileSpecificScanContext<IBeaconRegion> {
    public static final IBeaconScanContext DEFAULT = new Builder().build();
    private final List<IBeaconFilter> iBeaconFilters;
    private final Set<IBeaconRegion> iBeaconRegions;

    private IBeaconScanContext(Builder builder) {
        super(builder);
        ScanContextValidator.validateIBeaconRegionsCount(builder.iBeaconRegions);
        ScanContextValidator.validateIBeaconFiltersCount(builder.iBeaconFilterList);
        this.iBeaconRegions = Collections.unmodifiableSet(new HashSet(builder.iBeaconRegions));
        this.iBeaconFilters = Collections.unmodifiableList(new LinkedList(builder.iBeaconFilterList));
    }

    @Override
    public Collection<IBeaconRegion> getSpaces() {
        return this.iBeaconRegions;
    }

    public Collection<IBeaconFilter> getFilters() {
        return this.iBeaconFilters;
    }

    public static final class Builder
    extends AbstractProfileSpecificScanContext.Builder<IBeaconScanContext, Builder> {
        private List<IBeaconFilter> iBeaconFilterList = new LinkedList<IBeaconFilter>();
        private Set<IBeaconRegion> iBeaconRegions = new HashSet<IBeaconRegion>();

        public Builder setIBeaconFilters(Collection<? extends IBeaconFilter> filters) {
            SDKPreconditions.checkNotNull(filters, "Filters are null.");
            this.iBeaconFilterList.addAll(filters);
            return this;
        }

        public Builder setIBeaconRegions(Collection<IBeaconRegion> iBeaconRegions) {
            SDKPreconditions.checkNotNull(iBeaconRegions, "Regions collection is null");
            this.iBeaconRegions.addAll(iBeaconRegions);
            return this;
        }

        @Override
        public IBeaconScanContext build() {
            if (this.iBeaconRegions.isEmpty()) {
                this.iBeaconRegions.add(BeaconRegion.EVERYWHERE);
            }
            return new IBeaconScanContext(this);
        }

        @Override
        protected Builder getExtension() {
            return this;
        }
    }
}

