/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration.scan;

import com.kontakt.sdk.android.ble.configuration.scan.AbstractProfileSpecificScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContextValidator;
import com.kontakt.sdk.android.ble.device.EddystoneNamespace;
import com.kontakt.sdk.android.ble.filter.eddystone.TLMFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.UIDFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.URLFilter;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class EddystoneScanContext
extends AbstractProfileSpecificScanContext<IEddystoneNamespace> {
    public static final EddystoneScanContext DEFAULT = new Builder().build();
    private final Set<IEddystoneNamespace> eddystoneNamespaces;
    private final List<UIDFilter> uidFilters;
    private final List<URLFilter> urlFilters;
    private final List<TLMFilter> tlmFilters;
    private final Collection<EddystoneFrameType> triggerFrameTypes;

    private EddystoneScanContext(Builder builder) {
        super(builder);
        ScanContextValidator.validateNamespacesCount(builder.eddystoneNamespaces);
        ScanContextValidator.validateEddystoneUIDFiltersCount(builder.uidFilters);
        ScanContextValidator.validateEddystoneURLFiltersCount(builder.urlFilters);
        ScanContextValidator.validateEddystoneTLMFiltersCount(builder.tlmFilters);
        this.eddystoneNamespaces = Collections.unmodifiableSet(new HashSet(builder.eddystoneNamespaces));
        this.uidFilters = Collections.unmodifiableList(new LinkedList(builder.uidFilters));
        this.urlFilters = Collections.unmodifiableList(new LinkedList(builder.urlFilters));
        this.tlmFilters = Collections.unmodifiableList(new LinkedList(builder.tlmFilters));
        this.triggerFrameTypes = Collections.unmodifiableCollection(builder.eddystoneFrameTypes);
    }

    public Collection<UIDFilter> getUIDFilters() {
        return this.uidFilters;
    }

    public Collection<URLFilter> getURLFilters() {
        return this.urlFilters;
    }

    public Collection<TLMFilter> getTLMFilters() {
        return this.tlmFilters;
    }

    @Override
    public Collection<IEddystoneNamespace> getSpaces() {
        return this.eddystoneNamespaces;
    }

    public Collection<EddystoneFrameType> getTriggerFrameTypes() {
        return this.triggerFrameTypes;
    }

    public static final class Builder
    extends AbstractProfileSpecificScanContext.Builder<EddystoneScanContext, Builder> {
        private Set<IEddystoneNamespace> eddystoneNamespaces = new HashSet<IEddystoneNamespace>();
        private List<UIDFilter> uidFilters = new ArrayList<UIDFilter>();
        private List<URLFilter> urlFilters = new ArrayList<URLFilter>();
        private List<TLMFilter> tlmFilters = new ArrayList<TLMFilter>();
        private Collection<EddystoneFrameType> eddystoneFrameTypes = new HashSet<EddystoneFrameType>();

        @Override
        protected Builder getExtension() {
            return this;
        }

        @Override
        public EddystoneScanContext build() {
            if (this.eddystoneNamespaces.isEmpty()) {
                this.eddystoneNamespaces.add(EddystoneNamespace.EVERYWHERE);
            }
            return new EddystoneScanContext(this);
        }

        public Builder setUIDFilters(Collection<UIDFilter> eddystoneFilters) {
            SDKPreconditions.checkNotNull(eddystoneFilters, "Filters are null.");
            this.uidFilters.addAll(eddystoneFilters);
            return this;
        }

        public Builder setTLMFilters(Collection<TLMFilter> eddystoneFilters) {
            SDKPreconditions.checkNotNull(eddystoneFilters, "Filters are null.");
            this.tlmFilters.addAll(eddystoneFilters);
            return this;
        }

        public Builder setURLFilters(Collection<URLFilter> eddystoneFilters) {
            SDKPreconditions.checkNotNull(eddystoneFilters, "Filters are null.");
            this.urlFilters.addAll(eddystoneFilters);
            return this;
        }

        public Builder setEddystoneNamespaces(Collection<IEddystoneNamespace> eddystoneNamespaces) {
            SDKPreconditions.checkNotNull(eddystoneNamespaces, "Eddystone namespaces are null.");
            this.eddystoneNamespaces.addAll(eddystoneNamespaces);
            return this;
        }

        public Builder setTriggerFrameTypes(Collection<EddystoneFrameType> eddystoneFrames) {
            SDKPreconditions.checkNotNull(eddystoneFrames, "Eddystone trigger frames");
            this.eddystoneFrameTypes.addAll(eddystoneFrames);
            return this;
        }
    }
}

