/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration.scan;

import com.kontakt.sdk.android.ble.configuration.scan.ProfileSpecificScanContext;
import com.kontakt.sdk.android.ble.discovery.DistanceSort;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;

abstract class AbstractProfileSpecificScanContext<S>
implements ProfileSpecificScanContext<S> {
    private static final Collection<EventType> ALL_EVENT_TYPES = EnumSet.allOf(EventType.class);
    private final DistanceSort distanceSort;
    private final Collection<EventType> eventTypes;

    protected AbstractProfileSpecificScanContext(Builder builder) {
        this.distanceSort = builder.distanceSort;
        this.eventTypes = Collections.unmodifiableCollection(new HashSet(builder.eventTypes.isEmpty() ? ALL_EVENT_TYPES : builder.eventTypes));
    }

    @Override
    public DistanceSort getDistanceSort() {
        return this.distanceSort;
    }

    @Override
    public Collection<EventType> getEventTypes() {
        return this.eventTypes;
    }

    static abstract class Builder<B, T extends Builder> {
        private DistanceSort distanceSort = DistanceSort.DISABLED;
        private Collection<EventType> eventTypes = new HashSet<EventType>(EventType.values().length);

        Builder() {
        }

        protected abstract T getExtension();

        public abstract B build();

        public T setDistanceSort(DistanceSort distanceSort) {
            SDKPreconditions.checkNotNull(distanceSort, "Distance sort is null");
            this.distanceSort = distanceSort;
            return this.getExtension();
        }

        public T setEventTypes(Collection<EventType> eventTypes) {
            SDKPreconditions.checkNotNull(eventTypes, "Event types are null");
            this.eventTypes.addAll(eventTypes);
            return this.getExtension();
        }
    }
}

