/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration;

import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.concurrent.TimeUnit;

public class ScanPeriod {
    public static final long MINIMAL_ACTIVE_SCAN_PERIOD = TimeUnit.SECONDS.toMillis(3L);
    public static final long MINIMAL_PASSIVE_SCAN_PERIOD = TimeUnit.SECONDS.toMillis(2L);
    private final long activePeriod;
    private final long passivePeriod;
    public static final ScanPeriod RANGING = new ScanPeriod(TimeUnit.SECONDS.toMillis(10L), 0L);
    public static final ScanPeriod MONITORING = new ScanPeriod(TimeUnit.SECONDS.toMillis(5L), TimeUnit.SECONDS.toMillis(20L));

    public static ScanPeriod create(long activePeriodMillis, long passivePeriodMillis) {
        SDKPreconditions.checkArgument(activePeriodMillis >= MINIMAL_ACTIVE_SCAN_PERIOD, "Period must be greater than " + MINIMAL_ACTIVE_SCAN_PERIOD);
        SDKPreconditions.checkArgument(passivePeriodMillis >= MINIMAL_PASSIVE_SCAN_PERIOD, "Period must be greater than " + MINIMAL_PASSIVE_SCAN_PERIOD);
        return new ScanPeriod(activePeriodMillis, passivePeriodMillis);
    }

    private ScanPeriod(long activePeriod, long passivePeriod) {
        this.activePeriod = activePeriod;
        this.passivePeriod = passivePeriod;
    }

    public long getActivePeriod() {
        return this.activePeriod;
    }

    public long getPassivePeriod() {
        return this.passivePeriod;
    }

    public long getFullPeriod() {
        return this.activePeriod + this.passivePeriod;
    }
}

