/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDeviceEvent;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;

class IBeaconResolveRequest {
    private final IBeaconDevice fakeDevice;
    private final Integer sourceProximityManagerId;
    private final IBeaconRegion region;
    private final long timestamp;
    private ResolverType resolvedBy = ResolverType.NONE;
    private ResolveRequestStatus status;

    public IBeaconResolveRequest(Integer sourceProximityManagerId, IBeaconDevice beaconDevice, IBeaconRegion region, long timestamp) {
        this.sourceProximityManagerId = sourceProximityManagerId;
        this.fakeDevice = beaconDevice;
        this.region = region;
        this.timestamp = timestamp;
    }

    public IBeaconDevice getFakeDevice() {
        return this.fakeDevice;
    }

    public Integer getSourceProximityManagerId() {
        return this.sourceProximityManagerId;
    }

    public IBeaconRegion getRegion() {
        return this.region;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ResolverType getResolvedBy() {
        return this.resolvedBy;
    }

    public void setResolvedBy(ResolverType resolvedBy) {
        this.resolvedBy = resolvedBy;
    }

    public void setStatus(ResolveRequestStatus status) {
        this.status = status;
    }

    public ResolveRequestStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof IBeaconResolveRequest)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        IBeaconResolveRequest resolveRequest = (IBeaconResolveRequest)o;
        return SDKEqualsBuilder.start().equals(this.fakeDevice, resolveRequest.fakeDevice).equals(this.sourceProximityManagerId, resolveRequest.sourceProximityManagerId).equals(this.region, resolveRequest.region).equals(this.timestamp, resolveRequest.timestamp).equals((Object)this.resolvedBy, (Object)resolveRequest.resolvedBy).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.fakeDevice).append(this.sourceProximityManagerId).append(this.region).append(this.timestamp).append((Object)this.resolvedBy).build();
    }

    static IBeaconResolveRequest of(int sourceProximityManagerId, BluetoothDeviceEvent bluetoothDeviceEvent) {
        IBeaconDeviceEvent iBeaconDeviceEvent = (IBeaconDeviceEvent)bluetoothDeviceEvent;
        EventType eventType = iBeaconDeviceEvent.getEventType();
        SDKPreconditions.checkArgument(EventType.DEVICE_DISCOVERED == eventType, "Cannot create resolve request for other event type than DEVICE_DISCOVERED!");
        List<IBeaconDevice> discoveredDeviceList = iBeaconDeviceEvent.getDeviceList();
        SDKPreconditions.checkState(discoveredDeviceList.size() == 1, "Resolve request must be created for each one discovered device!");
        int proximityManagerId = sourceProximityManagerId;
        IBeaconDevice beaconDevice = discoveredDeviceList.get(0);
        IBeaconRegion region = iBeaconDeviceEvent.getRegion();
        long timestamp = bluetoothDeviceEvent.getTimestamp();
        return new IBeaconResolveRequest(proximityManagerId, beaconDevice, region, timestamp);
    }
}

