/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDeviceEvent;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;

class EddystoneResolveRequest {
    private final IEddystoneDevice fakeDevice;
    private final Integer sourceProximityManagerId;
    private final IEddystoneNamespace namespace;
    private final long timestamp;
    private ResolverType resolvedBy = ResolverType.NONE;
    private ResolveRequestStatus status;

    public EddystoneResolveRequest(Integer sourceProximityManagerId, IEddystoneDevice eddystoneDevice, IEddystoneNamespace namespace, long timestamp) {
        this.sourceProximityManagerId = sourceProximityManagerId;
        this.fakeDevice = eddystoneDevice;
        this.namespace = namespace;
        this.timestamp = timestamp;
    }

    public IEddystoneDevice getFakeDevice() {
        return this.fakeDevice;
    }

    public Integer getSourceProximityManagerId() {
        return this.sourceProximityManagerId;
    }

    public IEddystoneNamespace getNamespace() {
        return this.namespace;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ResolverType getResolvedBy() {
        return this.resolvedBy;
    }

    public void setResolvedBy(ResolverType resolvedBy) {
        this.resolvedBy = resolvedBy;
    }

    public void setStatus(ResolveRequestStatus status) {
        this.status = status;
    }

    public ResolveRequestStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EddystoneResolveRequest)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        EddystoneResolveRequest resolveRequest = (EddystoneResolveRequest)o;
        return SDKEqualsBuilder.start().equals(this.fakeDevice, resolveRequest.fakeDevice).equals(this.sourceProximityManagerId, resolveRequest.sourceProximityManagerId).equals(this.namespace, resolveRequest.namespace).equals(this.timestamp, resolveRequest.timestamp).equals((Object)this.resolvedBy, (Object)resolveRequest.resolvedBy).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.fakeDevice).append(this.sourceProximityManagerId).append(this.namespace).append(this.timestamp).append((Object)this.resolvedBy).build();
    }

    static EddystoneResolveRequest of(int sourceProximityManagerId, BluetoothDeviceEvent bluetoothDeviceEvent) {
        EddystoneDeviceEvent iBeaconDeviceEvent = (EddystoneDeviceEvent)bluetoothDeviceEvent;
        EventType eventType = iBeaconDeviceEvent.getEventType();
        SDKPreconditions.checkArgument(EventType.DEVICE_DISCOVERED == eventType, "Cannot create resolve request for other event type than DEVICE_DISCOVERED!");
        List<IEddystoneDevice> discoveredDeviceList = iBeaconDeviceEvent.getDeviceList();
        SDKPreconditions.checkState(discoveredDeviceList.size() == 1, "Resolve request must be created for each one discovered device!");
        int proximityManagerId = sourceProximityManagerId;
        IEddystoneDevice beaconDevice = discoveredDeviceList.get(0);
        IEddystoneNamespace namespace = iBeaconDeviceEvent.getNamespace();
        long timestamp = bluetoothDeviceEvent.getTimestamp();
        return new EddystoneResolveRequest(proximityManagerId, beaconDevice, namespace, timestamp);
    }
}

