package com.kontakt.sdk.android.common.util;

/**
 * Convenience Constants.
 */
public final class Constants {

  private Constants() {
  }

  /**
   * The FIRMWARE constant.
   */
  public static final String FIRMWARE = "firmware";
  /**
   * The UNIQUE ID constant.
   */
  public static final String UNIQUE_ID = "uniqueId";

  /**
   * The ID constant.
   */
  public static final String ID = "id";

  public static final String TIMESTAMP = "timestamp";

  /**
   * Convenience constants.
   */
  public static final class Devices {
    /**
     * Convenience constant CREDENTIALS.
     */
    public static final String CREDENTIALS = "credentials";
    /**
     * The PROXIMITY.
     */
    public static final String PROXIMITY = "proximity";
    /**
     * Convenience constant DEVICE_TYPE.
     */
    public static final String DEVICE_TYPE = "deviceType";
    /**
     * The MAJOR.
     */
    public static final String MAJOR = "major";
    /**
     * The MINOR.
     */
    public static final String MINOR = "minor";
    /**
     * The MAC address.
     */
    public static final String MAC_ADDRESS = "mac";
    /**
     * The TX POWER.
     */
    public static final String TX_POWER = "txPower";
    /**
     * The ALIAS.
     */
    public static final String ALIAS = "alias";
    /**
     * The INTERVAL.
     */
    public static final String INTERVAL = "interval";
    /**
     * The CONTENT ACTIONS.
     */
    public static final String CONTENT_ACTIONS = "contentActions";
    /**
     * The BROWSER ACTIONS.
     */
    public static final String BROWSER_ACTIONS = "browserActions";
    /**
     * The NAME.
     */
    public static final String NAME = "name";
    /**
     * The PASSWORD.
     */
    public static final String PASSWORD = "password";
    /**
     * The MASTER PASSWORD.
     */
    public static final String MASTER_PASSWORD = "masterPassword";
    /**
     * The ACTIONS COUNT.
     */
    public static final String ACTIONS_COUNT = "actionsCount";
    /**
     * The MANAGER ID.
     */
    public static final String MANAGER_ID = "managerId";
    /**
     * The COMPANY IDENTIFIER.
     */
    public static final String COMPANY_IDENTIFIER = "company_identifier";
    /**
     * The ACCURACY.
     */
    public static final String ACCURACY = "accuracy";

    /**
     * Convenience constant WIFI_SCAN_INTERVAL.
     */
    public static final String WIFI_SCAN_INTERVAL = "wifiScanInterval";
    /**
     * Convenience constant BLE_SCAN_INTERVAL.
     */
    public static final String BLE_SCAN_INTERVAL = "bleScanInterval";
    /**
     * Convenience constant WORKING_MODE.
     */
    public static final String WORKING_MODE = "workingMode";

    /**
     * Convenience constant DEFAULT_SSID_AUTH.
     */
    public static final String DEFAULT_SSID_AUTH = "defaultSSIDAuth";

    /**
     * Convenience constant MAINTENANCE_START.
     */
    public static final String MAINTENANCE_START = "maintenanceStart";

    /**
     * Convenience constant DATA_SEND_INTERVAL.
     */
    public static final String DATA_SEND_INTERVAL = "dataSendInterval";

    /**
     * Convenience constant DEFAULT_SSID_CRYPT.
     */
    public static final String DEFAULT_SSID_CRYPT = "defaultSSIDCrypt";

    /**
     * Convenience constant DEFAULT_SSID_NAME.
     */
    public static final String DEFAULT_SSID_NAME = "defaultSSIDName";

    /**
     * Convenience constant MAINTENANCE_END.
     */
    public static final String MAINTENANCE_END = "maintenanceEnd";

    /**
     * Convenience constant BLE_SCAN_DURATION.
     */
    public static final String BLE_SCAN_DURATION = "bleScanDuration";

    public static final String BATTERY = "battery";
    public static final String MANUFACTURER_NAME = "manufacturer";
    public static final String FIRMWARE_REVISION = "firmware";
    public static final String HARDWARE_REVISION = "hardware";

    public static final String ACTIVE_PROFILE = "activeProfile";

    public static final String FIRMWARE_VERSION_NONE = "-1";

    public static final String ADDRESS = "address";

    public static final String RSSI = "rssi";

    public static final String ACCESS = "access";

    public static final String FIRMWARE_VERSION = "firmware";

    public static final String LATITUDE = "lat";

    public static final String LONGITUDE = "lng";

    public static final String SPECIFICATION = "specification";

    public static final String MODEL = "model";

    public static final String PROFILES = "profiles";

    public static final String HASHING_POLICY = "hashingPolicy";

    public static final String SHUFFLED = "shuffled";

    public static final String SECURE = "secure";

    public static final String SECURE_PROXIMITY = "secureProximity";

    public static final String SECURE_NAMESPACE = "secureNamespace";
  }

  public static final class Eddystone {

    private Eddystone() {
    }

    public static final String NAMESPACE_ID = "namespaceId";

    public static final String INSTANCE_ID = "instanceId";

    public static final String URL = "url";

    public static final String NAMESPACE = "namespace";

    public static final String TELEMETRY = "telemetry";

    public static final int NAMESPACE_MAX_BYTES_LENGTH = 10;

    public static final int INSTANCE_MAX_BYTES_LENGTH = 6;

    public static final int MASTER_PASSWORD_EXACT_BYTES_LENGTH = 6;

    public static final int PASSWORD_EXACT_BYTES_LENGTH = 4;

    public static final int URL_MAX_BYTES_LENGTH = 18;
  }

  public static final class TLM {

    public static final String BATTERY_VOLTAGE = "battery_voltage";

    public static final String TEMPERATURE = "temperature";

    public static final String PDU_COUNT = "pdu_count";

    public static final String TIME_SINCE_POWER_UP = "time_since_power_up";

    public static final String VERSION = "version";
  }

  /**
   * Convenience constants.
   */
  public static final class Venue {

    private Venue() {
    }

    /**
     * The NAME.
     */
    public static final String NAME = "name";
    /**
     * The DESCRIPTION.
     */
    public static final String DESCRIPTION = "description";
    /**
     * The COVER TYPE.
     */
    public static final String COVER_TYPE = "coverType";
    /**
     * The DEVICES.
     */
    public static final String DEVICES = "devices";
    /**
     * The MANAGER_ID.
     */
    public static final String MANAGER_ID = "managerId";
    /**
     * The DEVICES COUNT.
     */
    public static final String DEVICES_COUNT = "devicesCount";
    /**
     * The IMAGE.
     */
    public static final String IMAGE = "image";
    /**
     * The PROXIMITY.
     */
    public static final String PROXIMITY = "proximity";
    /**
     * The MAJOR.
     */
    public static final String MAJOR = "major";
    /**
     * The MINOR.
     */
    public static final String MINOR = "minor";

    public static final String LATITUDE = "lat";

    public static final String LONGITUDE = "lng";
  }

  /**
   * Convenience constants.
   */
  public static final class Action {

    private Action() {
    }

    /**
     * The ACTION _ tYPE.
     */
    public static final String ACTION_TYPE = "actionType";
    /**
     * The ACTION _ tYPE _ bROWSER.
     */
    public static final String ACTION_TYPE_BROWSER = "BROWSER";
    /**
     * The ACTION _ tYPE _ cONTENT.
     */
    public static final String ACTION_TYPE_CONTENT = "CONTENT";
    /**
     * The PROXIMITY.
     */
    public static final String PROXIMITY = "proximity";
    /**
     * The URL.
     */
    public static final String URL = "url";
    /**
     * The CONTENT _ lENGTH.
     */
    public static final String CONTENT_LENGTH = "contentLength";
    /**
     * The CONTENT _ tYPE.
     */
    public static final String CONTENT_TYPE = "contentType";
    /**
     * The CONTENT.
     */
    public static final String CONTENT = "content";
    /**
     * The CONTENT _ cATEGORY.
     */
    public static final String CONTENT_CATEGORY = "contentCategory";
  }

  /**
   * Convenience constants.
   */
  public static final class Manager {

    private Manager() {
    }

    /**
     * The SUPERVISOR _ iD.
     */
    public static final String SUPERVISOR_ID = "supervisorId";
    /**
     * The FIRST _ nAME.
     */
    public static final String FIRST_NAME = "firstName";
    /**
     * The LAST _ nAME.
     */
    public static final String LAST_NAME = "lastName";
    /**
     * The EMAIL.
     */
    public static final String EMAIL = "email";
    /**
     * The ROLE.
     */
    public static final String ROLE = "role";
    /**
     * The PASSWORD.
     */
    public static final String PASSWORD = "password";
  }

  /**
   * Convenience constants.
   */
  public static final class Firmware {

    private Firmware() {
    }

    /**
     * The IMPORTANT.
     */
    public static final String IMPORTANT = "important";
    /**
     * The VALID _ vERSIONS.
     */
    public static final String VALID_VERSIONS = "validVersions";
    /**
     * The DESCRIPTION.
     */
    public static final String DESCRIPTION = "description";
    /**
     * The NAME.
     */
    public static final String NAME = "name";
    /**
     * The FILE.
     */
    public static final String FILE = "file";
    /**
     * The URL.
     */
    public static final String URL = "url";

    /**
     * The DEVICE_TYPE
     */
    public static final String DEVICE_TYPE = "deviceType";

    /**
     * The SCHEDULED
     */
    public static final String SCHEDULED = "scheduled";

    /**
     * The OPTIONAL
     */
    public static final String OPTIONAL = "optional";

    /**
     * The UNIQUE_ID
     */
    public static final String UNIQUE_ID = "uniqueId";

    /**
     * The FIRMWARES
     */
    public static final String FIRMWARES = "firmwares";
  }

  /**
   * TConvenience constants.
   */
  public static final class Config {

    private Config() {
    }

    /**
     * The PROXIMITY.
     */
    public static final String PROXIMITY = "proximity";
    /**
     * The MAJOR.
     */
    public static final String MAJOR = "major";
    /**
     * The MINOR.
     */
    public static final String MINOR = "minor";
    /**
     * The INTERVAL.
     */
    public static final String INTERVAL = "interval";
    /**
     * The ALIAS.
     */
    public static final String ALIAS = "alias";
    /**
     * The TX _ pOWER.
     */
    public static final String TX_POWER = "txPower";
    /**
     * The UNIQUE _ iD.
     */
    public static final String UNIQUE_ID = "uniqueId";

    public static final String SHUFFLED = "shuffled";
  }

  public static final class Proximity {
    public static final String PROXIMITY_UUID = "proximity";
    public static final String SECURE_PROXIMITY_UUID = "secureProximity";
    public static final String SHUFFLED = "shuffled";
    public static final String SHARED = "shared";
  }

  public static final class Region {
    public static final String UUID = "uuid";
    public static final String MAJOR = "major";
    public static final String MINOR = "minor";
    public static final String SHUFFLED = "shuffled";
    public static final String IDENTIFIER = "identifier";
  }

}
