package com.kontakt.sdk.android.common.model;

import android.os.Parcel;

/**
 * Event that collects info about rssi value of a single device at given point of time.
 */
public class ScanEvent extends Event {

  /**
   * Parcelable CREATOR constant.
   */
  public static final Creator<ScanEvent> CREATOR = new Creator<ScanEvent>() {
    @Override public ScanEvent createFromParcel(Parcel source) {
      return new ScanEvent(source);
    }

    @Override public ScanEvent[] newArray(int size) {
      return new ScanEvent[size];
    }
  };

  private final double rssi;

  protected ScanEvent(EventType eventType, long timestamp, String uniqueId, double rssi) {
    super(eventType, timestamp, uniqueId);
    this.rssi = rssi;
  }

  protected ScanEvent(Parcel in) {
    super(in);
    this.rssi = in.readDouble();
  }

  @Override public int describeContents() {
    return 0;
  }

  @Override public void writeToParcel(Parcel dest, int flags) {
    super.writeToParcel(dest, flags);
    dest.writeDouble(this.rssi);
  }

  public double getRssi() {
    return rssi;
  }
}
