package com.kontakt.sdk.android.common.model;

/**
 * Enumeration of interleave packet type.
 */
public enum PacketType {

  /**
   * Eddystone UID packet.
   */
  EDDYSTONE_UID("UID"),

  /**
   * Eddystone URL packet.
   */
  EDDYSTONE_URL("URL"),

  /**
   * Eddystone TLM packet.
   */
  EDDYSTONE_TLM("TLM"),

  /**
   * iBeacon packet.
   */
  IBEACON("IBEACON");

  private final String shortName;

  PacketType(String shortName) {
    this.shortName = shortName;
  }

  public String getShortName() {
    return shortName;
  }

  public static PacketType fromShortName(String value) {
    for (PacketType packetType : PacketType.values()) {
      if (packetType.getShortName().equals(value)) {
        return packetType;
      }
    }
    throw new IllegalArgumentException("Can't create PacketType from given string");
  }
}
