package com.kontakt.sdk.android.common.model;

import android.os.Parcel;

/**
 * Event that collects info about battery level of a single device at given point of time.
 */
public class MonitoringEvent extends Event {

  /**
   * Parcelable CREATOR constant.
   */
  public static final Creator<MonitoringEvent> CREATOR = new Creator<MonitoringEvent>() {
    @Override public MonitoringEvent createFromParcel(Parcel source) {
      return new MonitoringEvent(source);
    }

    @Override public MonitoringEvent[] newArray(int size) {
      return new MonitoringEvent[size];
    }
  };

  private final int batteryLevel;

  protected MonitoringEvent(EventType eventType, long timestamp, String uniqueId, int batteryLevel) {
    super(eventType, timestamp, uniqueId);
    this.batteryLevel = batteryLevel;
  }

  protected MonitoringEvent(Parcel in) {
    super(in);
    this.batteryLevel = in.readInt();
  }

  @Override public int describeContents() {
    return 0;
  }

  @Override public void writeToParcel(Parcel dest, int flags) {
    super.writeToParcel(dest, flags);
    dest.writeInt(this.batteryLevel);
  }

  public int getBatteryLevel() {
    return batteryLevel;
  }
}
