package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.List;

/**
 * Aggregated set of {@link Event} objects.
 */
public class EventPacket implements Parcelable {

  private long timestamp;
  private List<Event> events = new ArrayList<>();

  /**
   * Creates new event packet from list of {@link Event} objects and a timestamp.
   * @param events the list of events.
   * @param timestamp the timestamp.
   * @return new event packet instance.
   */
  public static EventPacket from(final List<Event> events, long timestamp) {
    SDKPreconditions.checkNotNull(events, "events cannot be null");
    return new EventPacket(events, timestamp);
  }

  private EventPacket(List<Event> events, long timestamp) {
    this.events = events;
    this.timestamp = timestamp;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public List<Event> getEvents() {
    return events;
  }

  @Override public int describeContents() {
    return 0;
  }

  @Override public void writeToParcel(Parcel dest, int flags) {
    dest.writeLong(this.timestamp);
    dest.writeList(events);
  }

  protected EventPacket(Parcel in) {
    this.timestamp = in.readLong();
    in.readList(events, Event.class.getClassLoader());
  }

  public static final Parcelable.Creator<EventPacket> CREATOR =
      new Parcelable.Creator<EventPacket>() {
        @Override public EventPacket createFromParcel(Parcel source) {
          return new EventPacket(source);
        }

        @Override public EventPacket[] newArray(int size) {
          return new EventPacket[size];
        }
      };
}
