package com.kontakt.sdk.android.common;

import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import java.util.Arrays;

/**
 * File data wraps bytes array obtained from HTTP response when content load is desired.
 */
public final class FileData {

    private final byte[] data;

    public static FileData of(final byte[] data) {
        return new FileData(data);
    }

    public static FileData empty() {
        return new FileData(null);
    }

    /**
     * Instantiates a new File data.
     *
     * @param data the data
     */
    private FileData(byte[] data) {
        this.data = data;
    }

    /**
     * Gets data.
     *
     * @return the byte array
     */
    public byte[] getData() {
        return data;
    }

    @Override
    public boolean equals(Object obj) {
        if(obj == null || !(obj instanceof FileData)) {
            return false;
        }

        FileData fileData = (FileData) obj;

        return Arrays.equals(data, fileData.data);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.init()
                              .append(data)
                              .build();
    }
}
