package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Configs;
import com.kontakt.sdk.android.common.model.Config;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.QueryMap;

public interface ConfigsService {

  @GET("/config")
  Call<Configs> getConfigs(@QueryMap Map<String, String> params);

  @GET("/config")
  Call<Configs> getConfigs(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @GET("/config/encrypt")
  Call<Configs> getSecureConfigs(@QueryMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/config/create")
  Call<Config[]> createConfig(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("config/delete")
  Call<String> deletePendingConfigs(@FieldMap Map<String, String> params);

}
