package com.kontakt.sdk.android.cloud.api.executor.presets;

import com.kontakt.sdk.android.cloud.api.PresetsApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.PresetsService;
import com.kontakt.sdk.android.common.model.Preset;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

/**
 * Request executor provided by {@link PresetsApi}. Use this class if you want to fetch
 * single preset through fluent API in chained fashion, for example:
 * <pre>
 *   <code>
 *   IKontaktCloud kontaktCloud = KontaktCloud.newInstance();
 *   kontaktCloud.presets().fetch(name).execute();
 *   </code>
 * </pre>
 */
public class PresetRequestExecutor extends RequestExecutor<Preset> {

  private final PresetsService presetsService;

  private final String name;

  /**
   * Constructs request executor initialized with corresponding service class and preset's name.
   * @param presetsService the presets API service.
   * @param name the preset's name.
   */
  public PresetRequestExecutor(final PresetsService presetsService, final String name) {
    this.presetsService = presetsService;
    this.name = name;
  }

  /**
   * {@inheritDoc}
   */
  @Override protected Call<Preset> prepareCall() {
    return presetsService.getPreset(name);
  }

  @Override protected Map<String, String> params() {
    return new HashMap<>();
  }
}
