package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.DevicesApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.common.model.Credentials;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

/**
 * Request executor provided by {@link DevicesApi}. Use this class if you want to get
 * single device credentials through fluent API in chained fashion, for instance:
 * <pre>
 *   <code>
 *   IKontaktCloud kontaktCloud = KontaktCloud.newInstance();
 *   Credentials credentials = kontaktCloud.devices().credentials(deviceID).execute();
 *   </code>
 * </pre>
 */
public class CredentialsRequestExecutor extends RequestExecutor<Credentials> {

  private final DevicesService devicesService;

  private final String uniqueId;

  /**
   * Constructs request executor initialized with corresponding service class and device unique ID.
   * @param devicesService the devices API service.
   * @param uniqueId device unique identifier.
   */
  public CredentialsRequestExecutor(final DevicesService devicesService, final String uniqueId) {
    this.devicesService = devicesService;
    this.uniqueId = uniqueId;
  }

  /**
   * {@inheritDoc}
   */
  @Override protected Call<Credentials> prepareCall() {
    return devicesService.getDeviceCredentials(uniqueId);
  }

  @Override protected Map<String, String> params() {
    return new HashMap<>();
  }
}
