package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.proximities.ProximitiesRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ProximitiesService;

/**
 * An abstract representation of Proximities API endpoint. Provides executors that can be
 * used to handle all proximity-related requests.
 */
public class ProximitiesApi {

  private final ProximitiesService proximitiesService;

  /**
   * Constructs Proximities API endpoint initialized with corresponding service class.
   * @param proximitiesService the proximities API service.
   */
  public ProximitiesApi(final ProximitiesService proximitiesService) {
    this.proximitiesService = proximitiesService;
  }

  /**
   * Provides executor that can be used to obtain proximities.
   * @return the request executor.
   */
  public ProximitiesRequestExecutor fetch() {
    return new ProximitiesRequestExecutor(proximitiesService);
  }
}
