package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.namespaces.NamespacesRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.NamespacesService;

/**
 * An abstract representation of Namespaces API endpoint. Provides executors that can be
 * used to handle all namespace-related requests.
 */
public class NamespacesApi {

  private final NamespacesService namespacesService;

  /**
   * Constructs Namespaces API endpoint initialized with corresponding service class.
   * @param namespacesService the namespaces API service.
   */
  public NamespacesApi(final NamespacesService namespacesService) {
    this.namespacesService = namespacesService;
  }

  /**
   * Provides executor that can be used to obtain namespaces.
   * @return the request executor.
   */
  public NamespacesRequestExecutor fetch() {
    return new NamespacesRequestExecutor(namespacesService);
  }

}
