package com.kontakt.sdk.android.ble.util;

import com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.IBeaconScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import java.util.Collection;

import static com.kontakt.sdk.android.common.util.SDKPreconditions.checkNotNull;

public class ScanContextUtils {

  /**
   * Returns deep cloned instance of immutable {@link ScanContext} with new Regions and Namespaces
   *
   * @param oldContext old context
   * @param regions new regions
   * @param namespaces new namespaces
   * @return new ScanContext
   */
  public static ScanContext cloneWithNewSpaces(ScanContext oldContext, Collection<IBeaconRegion> regions,
      Collection<IEddystoneNamespace> namespaces) {
    checkNotNull(oldContext);
    checkNotNull(regions);
    checkNotNull(namespaces);

    IBeaconScanContext oldIBeaconContext = oldContext.getIBeaconScanContext();
    EddystoneScanContext oldEddystoneContext = oldContext.getEddystoneScanContext();

    return cloneBuilder(oldContext).setEddystoneScanContext(
        new EddystoneScanContext.Builder().setTriggerFrameTypes(oldEddystoneContext.getTriggerFrameTypes())
            .setURLFilters(oldEddystoneContext.getURLFilters())
            .setTLMFilters(oldEddystoneContext.getTLMFilters())
            .setUIDFilters(oldEddystoneContext.getUIDFilters())
            .setDistanceSort(oldEddystoneContext.getDistanceSort())
            .setEventTypes(oldEddystoneContext.getEventTypes())
            .setEddystoneNamespaces(namespaces)
            .build())
        .setIBeaconScanContext(new IBeaconScanContext.Builder().setIBeaconFilters(oldIBeaconContext.getFilters())
            .setEventTypes(oldIBeaconContext.getEventTypes())
            .setDistanceSort(oldIBeaconContext.getDistanceSort())
            .setIBeaconRegions(regions)
            .build())
        .build();
  }

  /**
   * Clones Builder with values from given ScanContext
   *
   * @param scanContext ScanContext
   * @return new ScanContext builder instance
   */
  public static ScanContext.Builder cloneBuilder(ScanContext scanContext) {
    return new ScanContext.Builder()
        .setIBeaconScanContext(scanContext.getIBeaconScanContext())
        .setEddystoneScanContext(scanContext.getEddystoneScanContext())
        .setScanMode(scanContext.getScanMode())
        .setScanPeriod(scanContext.getScanPeriod())
        .setForceScanConfiguration(scanContext.getForceScanConfiguration())
        .setActivityCheckConfiguration(scanContext.getActivityCheckConfiguration())
        .setDevicesUpdateCallbackInterval(scanContext.getDevicesUpdateCallbackInterval())
        .setRssiCalculator(scanContext.getRssiCalculator());
  }
}
