package com.kontakt.sdk.android.ble.service;

import android.util.SparseArray;
import com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.IBeaconScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;

final class ServiceScanConfiguration {

  static final Item NULL = new Item(
      new ScanContext.Builder().setEddystoneScanContext(EddystoneScanContext.DEFAULT).setIBeaconScanContext(IBeaconScanContext.DEFAULT).build(),
      ScanConfiguration.NULL, ForceScanScheduler.DISABLED, ScanController.NULL);

  private final SparseArray<Item> scanConfigurationMap = new SparseArray<Item>() {
    @Override
    public Item get(int key) {
      return super.get(key, NULL);
    }
  };

  private final SparseArray<ProximityService.State> scanStateMap = new SparseArray<ProximityService.State>() {
    @Override
    public ProximityService.State get(int key) {
      return super.get(key, ProximityService.State.IDLE);
    }
  };

  ProximityService.State getState(final int proximityManagerId) {
    return scanStateMap.get(proximityManagerId);
  }

  void updateState(int proximityManagerId, ProximityService.State newState) {
    scanStateMap.put(proximityManagerId, newState);
  }

  ScanContext getScanContext(final int proximityManagerId) {
    return scanConfigurationMap.get(proximityManagerId).scanContext;
  }

  ScanConfiguration getScanConfiguration(final int proximityManagerId) {
    return scanConfigurationMap.get(proximityManagerId).scanConfiguration;
  }

  ForceScanScheduler getForceScanScheduler(final int proximityManagerId) {
    return scanConfigurationMap.get(proximityManagerId).forceScanScheduler;
  }

  ScanController getScanController(final int proximityManagerId) {
    return scanConfigurationMap.get(proximityManagerId).scanController;
  }

  void addListener(int proximityManagerId, InternalProximityListener proximityListener) {
    scanConfigurationMap.get(proximityManagerId).scanConfiguration.addListener(proximityListener);
  }

  void removeListener(int proximityManagerId, InternalProximityListener proximityListener) {
    scanConfigurationMap.get(proximityManagerId).scanConfiguration.removeListener(proximityListener);
  }

  void clear() {
    scanConfigurationMap.clear();
    scanStateMap.clear();
  }

  void add(final int proximityManagerId, Item item) {
    scanConfigurationMap.put(proximityManagerId, item);
  }

  Item get(final int proximityManagerId) {
    return scanConfigurationMap.get(proximityManagerId);
  }

  int size() {
    return scanConfigurationMap.size();
  }

  Item remove(final int proximityManagerId) {
    final Item item = scanConfigurationMap.get(proximityManagerId);

    scanStateMap.remove(proximityManagerId);
    scanConfigurationMap.remove(proximityManagerId);

    return item;
  }

  static final class Item {
    final ScanContext scanContext;
    final ScanConfiguration scanConfiguration;
    final ForceScanScheduler forceScanScheduler;
    final ScanController scanController;

    Item(ScanContext scanContext, ScanConfiguration scanConfiguration, ForceScanScheduler forceScanScheduler, ScanController scanController) {
      this.scanContext = scanContext;
      this.scanConfiguration = scanConfiguration;
      this.forceScanScheduler = forceScanScheduler;
      this.scanController = scanController;
    }
  }
}
