package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.os.Build;
import android.os.Messenger;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.common.log.Logger;
import java.util.ArrayList;
import java.util.List;

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
final class ScanCompatL extends ScanCompat {

  private static final List<ScanFilter> EMPTY_SCAN_FILTERS = new ArrayList<ScanFilter>();

  public ScanConfiguration createScanConfiguration(ListenerAccessor listenerAccessor, ScanContext scanContext, Messenger messenger) {
    final BleScanCallback scanCallback = Callbacks.newCallback(
        new Callbacks.Configuration.Builder()
            .addMonitoringListeners(listenerAccessor.getMonitoringListeners())
            .setScanContext(scanContext)
            .setServiceMessenger(messenger)
            .build());

    final ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(scanContext.getScanMode().getCode()).build();
    final BleScanCallback callbackL = CallbacksL.newCallback(scanCallback);

    return new AbstractScanConfigurationL(scanContext, callbackL) {
      @Override
      public ScanSettings getScanSettings() {
        return scanSettings;
      }
    };
  }

  public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
    return new ScanController.Builder().setScanPeriod(configuration.getScanContext().getScanPeriod())
        .setScanActiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration))
        .setScanPassiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration))
        .setForceScanScheduler(forceScanScheduler)
        .build();
  }

  public ForceScanScheduler createForceScanScheduler(final ScanConfiguration configuration) {
    final ScanContext scanContext = configuration.getScanContext();
    if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
      return ForceScanScheduler.DISABLED;
    }
    return new ForceScanScheduler(RunnersL.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
  }

  @SuppressWarnings("MissingPermission")
  public void onScanStart(final ScanConfiguration configuration) {
    final ScanConfigurationL scanConfiguration = (ScanConfigurationL) configuration;
    final ScanSettings scanSettings = scanConfiguration.getScanSettings();
    final ScanCallback scanCallback = (ScanCallback) scanConfiguration.getScanCallback();
    final BluetoothLeScanner scanner = getScanner();

    if (scanner != null) {
      scanner.startScan(EMPTY_SCAN_FILTERS, scanSettings, scanCallback);
    } else {
      Logger.e("onRangingStart(): BluetoothLeScanner is null.");
    }
  }

  @SuppressWarnings("MissingPermission")
  public void onScanStop(BleScanCallback callback) {
    if (callback != null) {
      final ScanCallback scanCallback = (ScanCallback) callback;
      final BluetoothLeScanner scanner = getScanner();
      if (scanner != null) {
        scanner.flushPendingScanResults(scanCallback);
        scanner.stopScan(scanCallback);
      }
    }
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  private static BluetoothLeScanner getScanner() {
    BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
    if (adapter != null) {
      return adapter.getBluetoothLeScanner();
    }
    return null;
  }

}
