package com.kontakt.sdk.android.ble.service;

import android.os.Build;

public class ScanCompatFactory {

  public static ScanCompat createScanCompat() {
    if(isLollipopOrHigher()) {
      return new ScanCompatL();
    } else {
      return new ScanCompatJB();
    }
  }

  private static boolean isLollipopOrHigher() {
    return Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP;
  }
}
