/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kontakt.sdk.android.ble.math;

/**
 * Base interface implemented by all statistics.
 */
interface UnivariateStatistic {
  /**
   * Returns the result of evaluating the statistic over the input array.
   *
   * @param values input array
   * @return the value of the statistic applied to the input array
   * @throws NullPointerException if values is null
   */
  double evaluate(double[] values);

  /**
   * Returns the result of evaluating the statistic over the specified entries
   * in the input array.
   *
   * @param values the input array
   * @param begin the index of the first element to include
   * @param length the number of elements to include
   * @return the value of the statistic applied to the included array entries
   * @throws IllegalStateException if values is null or the indices are invalid
   */
  double evaluate(double[] values, int begin, int length);
}
