package com.kontakt.sdk.android.ble.manager.configuration;

import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilters;
import com.kontakt.sdk.android.ble.filter.eddystone.TLMFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.UIDFilter;
import com.kontakt.sdk.android.ble.filter.eddystone.URLFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilters;
import java.util.Collection;

public interface FiltersConfigurator {

  /**
   * Add single {@link IBeaconFilter}.
   * <br>
   * See {@link IBeaconFilters} for predefined filters.
   *
   * @param filter IBeacon filter to add
   * @return ProximityManagerFilters builder
   */
  FiltersConfigurator iBeaconFilter(IBeaconFilter filter);

  /**
   * Add multiple {@link IBeaconFilter}.
   * <br>
   * See {@link IBeaconFilters} for predefined filters.
   *
   * @param filters IBeacon filters to add
   * @return void builder
   */
  FiltersConfigurator iBeaconFilters(Collection<IBeaconFilter> filters);

  /**
   * Add single Eddystone {@link UIDFilter}.
   * <br>
   * See {@link EddystoneFilters} for predefined filters.
   *
   * @param filter Eddystone UID filter to add.
   * @return void builder
   */
  FiltersConfigurator eddystoneUidFilter(UIDFilter filter);

  /**
   * Add multiple Eddystone {@link UIDFilter}.
   * <br>
   * See {@link EddystoneFilters} for predefined filters.
   *
   * @param filters Eddystone UID filters to add.
   * @return void builder
   */
  FiltersConfigurator eddystoneUidFilters(Collection<UIDFilter> filters);

  /**
   * Add single Eddystone {@link URLFilter}.
   * <br>
   * See {@link EddystoneFilters} for predefined filters.
   *
   * @param filter Eddystone URL filter to add.
   * @return void builder
   */
  FiltersConfigurator eddystoneUrlFilter(URLFilter filter);

  /**
   * Add multiple Eddystone {@link URLFilter}.
   * <br>
   * See {@link EddystoneFilters} for predefined filters.
   *
   * @param filters Eddystone URL filters to add.
   * @return void builder
   */
  FiltersConfigurator eddystoneUrlFilters(Collection<URLFilter> filters);

  /**
   * Add single Eddystone {@link TLMFilter}.
   * <br>
   * See {@link EddystoneFilters} for predefined filters.
   *
   * @param filter Eddystone TLM filters to add.
   * @return void builder
   */
  FiltersConfigurator eddystoneTlmFilter(TLMFilter filter);

  /**
   * Add multiple Eddystone {@link TLMFilter}.
   * <br>
   * See {@link EddystoneFilters} for predefined filters.
   *
   * @param filters Eddystone TLM filters to add.
   * @return void builder
   */
  FiltersConfigurator eddystoneTlmFilters(Collection<TLMFilter> filters);
}
