package com.kontakt.sdk.android.ble.filter.ibeacon;

import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconAdvertisingPacket;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;

/**
 * A predicate accepting iBeacon's advertising packet with specific proximity UUID value.
 */
public final class ProximityUUIDFilter implements IBeaconFilter {

    private final UUID filter;

    public ProximityUUIDFilter(final UUID proximityUUIDFilter) {
        SDKPreconditions.checkNotNull(proximityUUIDFilter, "Proximity UUID is null.");
        this.filter = proximityUUIDFilter;
    }

    @Override
    public boolean apply(IBeaconAdvertisingPacket target) {
        return filter.equals(target.getProximityUUID());
    }

    /**
     * Proivdes proximity UUID.
     *
     * @return the proximity uUID
     */
    public UUID getProximityUUID() {
        return filter;
    }
}