package com.kontakt.sdk.android.ble.filter.ibeacon;

import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconAdvertisingPacket;
import com.kontakt.sdk.android.common.util.IBeaconPropertyValidator;

/**
 * A predicate accepting iBeacon's advertising packet with specific minor value.
 */
public final class MinorFilter implements IBeaconFilter {

  private final int minor;

  public MinorFilter(final int minor) {
    IBeaconPropertyValidator.validateMinor(minor);
    this.minor = minor;
  }

  /**
   * Proivdes minor.
   *
   * @return the minor
   */
  public int getMinor() {
    return minor;
  }

  @Override
  public boolean apply(IBeaconAdvertisingPacket target) {
    return minor == target.getMinor();
  }
}